/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.graphics;

import com.github.rjeschke.neetutils.concurrent.Worker;
import com.github.rjeschke.neetutils.graphics.NColor;
import com.github.rjeschke.neetutils.graphics.NImage;
import com.github.rjeschke.neetutils.graphics.NImagePBlock;

class NImageBoxDownsampler
implements Worker<NImagePBlock> {
    final NImage image;
    final int fx;
    final int fy;

    NImageBoxDownsampler(NImage image, int fx, int fy) {
        this.image = image;
        this.fx = fx;
        this.fy = fy;
    }

    @Override
    public void run(NImagePBlock p) {
        float div = this.fx * this.fy;
        for (int y = 0; y < p.h; ++y) {
            for (int x = 0; x < p.w; ++x) {
                int rx = (x + p.x) * this.fx;
                int ry = (y + p.y) * this.fy;
                float a = 0.0f;
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                for (int y1 = 0; y1 < this.fy; ++y1) {
                    for (int x1 = 0; x1 < this.fx; ++x1) {
                        NColor c = this.image.getPixel(rx + x1, ry + y1);
                        a += c.a;
                        r += c.r;
                        g += c.g;
                        b += c.b;
                    }
                }
                p.pixels[x + y * p.w] = new NColor(a / div, r / div, g / div, b / div);
            }
        }
    }
}

