/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.graphics;

import com.github.rjeschke.neetutils.concurrent.Worker;
import com.github.rjeschke.neetutils.graphics.FilterKernel;
import com.github.rjeschke.neetutils.graphics.NColor;
import com.github.rjeschke.neetutils.graphics.NImage;
import com.github.rjeschke.neetutils.graphics.NImagePBlock;

class NImageFilter
implements Worker<NImagePBlock> {
    final NImage image;
    final FilterKernel filter;
    final int mode;

    NImageFilter(NImage image, FilterKernel filter, int mode) {
        this.image = image;
        this.filter = filter;
        this.mode = mode;
    }

    @Override
    public void run(NImagePBlock p) {
        if (this.mode == 0) {
            for (int y = 0; y < p.h; ++y) {
                for (int x = 0; x < p.w; ++x) {
                    float a = 0.0f;
                    float r = 0.0f;
                    float g = 0.0f;
                    float b = 0.0f;
                    for (int fy = 0; fy < this.filter.height; ++fy) {
                        for (int fx = 0; fx < this.filter.width; ++fx) {
                            float f = this.filter.xyf[fx + fy * this.filter.width];
                            int rx = p.x + x + fx + this.filter.offsx;
                            int ry = p.y + y + fy + this.filter.offsy;
                            NColor c = this.image.getPixel(rx, ry);
                            a += c.a * f;
                            r += c.r * f;
                            g += c.g * f;
                            b += c.b * f;
                        }
                    }
                    p.pixels[x + y * p.w] = new NColor(a, r, g, b);
                }
            }
        } else if (this.mode == 1) {
            for (int y = 0; y < p.h; ++y) {
                for (int x = 0; x < p.w; ++x) {
                    float a = 0.0f;
                    float r = 0.0f;
                    float g = 0.0f;
                    float b = 0.0f;
                    for (int fx = 0; fx < this.filter.width; ++fx) {
                        float f = this.filter.xf[fx];
                        int rx = p.x + x + fx + this.filter.offsx;
                        int ry = p.y + y;
                        NColor c = this.image.getPixel(rx, ry);
                        a += c.a * f;
                        r += c.r * f;
                        g += c.g * f;
                        b += c.b * f;
                    }
                    p.pixels[x + y * p.w] = new NColor(a, r, g, b);
                }
            }
        } else {
            for (int y = 0; y < p.h; ++y) {
                for (int x = 0; x < p.w; ++x) {
                    float a = 0.0f;
                    float r = 0.0f;
                    float g = 0.0f;
                    float b = 0.0f;
                    for (int fy = 0; fy < this.filter.height; ++fy) {
                        float f = this.filter.yf[fy];
                        int rx = p.x + x;
                        int ry = p.y + y + fy + this.filter.offsy;
                        NColor c = this.image.getPixel(rx, ry);
                        a += c.a * f;
                        r += c.r * f;
                        g += c.g * f;
                        b += c.b * f;
                    }
                    p.pixels[x + y * p.w] = new NColor(a, r, g, b);
                }
            }
        }
    }
}

