/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class BEIO {
    private BEIO() {
    }

    public static final void write8(OutputStream out, int value) throws IOException {
        out.write(value);
    }

    public static final void write16(OutputStream out, int value) throws IOException {
        out.write(value >> 8);
        out.write(value);
    }

    public static final void write24(OutputStream out, int value) throws IOException {
        out.write(value >> 16);
        out.write(value >> 8);
        out.write(value);
    }

    public static final void write32(OutputStream out, int value) throws IOException {
        out.write(value >> 24);
        out.write(value >> 16);
        out.write(value >> 8);
        out.write(value);
    }

    public static final void write64(OutputStream out, long value) throws IOException {
        out.write((int)(value >> 56));
        out.write((int)(value >> 48));
        out.write((int)(value >> 40));
        out.write((int)(value >> 32));
        out.write((int)(value >> 24));
        out.write((int)(value >> 16));
        out.write((int)(value >> 8));
        out.write((int)value);
    }

    public static final void writeFloat(OutputStream out, float value) throws IOException {
        BEIO.write32(out, Float.floatToIntBits(value));
    }

    public static final void writeDouble(OutputStream out, double value) throws IOException {
        BEIO.write64(out, Double.doubleToLongBits(value));
    }

    public static final void writeString(OutputStream out, String value, int length, int padding, String charsetName) throws IOException {
        byte[] bytes = value.getBytes(charsetName);
        if (bytes.length > length) {
            throw new IOException("String too long, expected max. " + length + ", got " + bytes.length);
        }
        for (int i = 0; i < length; ++i) {
            out.write(i < bytes.length ? bytes[i] : padding);
        }
    }

    public static final void writeString(OutputStream out, String value, int length, int padding) throws IOException {
        BEIO.writeString(out, value, length, padding, "UTF-8");
    }

    public static final void writeString8(OutputStream out, String value) throws IOException {
        byte[] bytes = value.getBytes("UTF-8");
        if (bytes.length > 255) {
            throw new IOException("String too long (" + bytes.length + ")");
        }
        BEIO.write8(out, bytes.length);
        out.write(bytes);
    }

    public static final void writeString16(OutputStream out, String value) throws IOException {
        byte[] bytes = value.getBytes("UTF-8");
        if (bytes.length > 65535) {
            throw new IOException("String too long (" + bytes.length + ")");
        }
        BEIO.write16(out, bytes.length);
        out.write(bytes);
    }

    public static final void writeString32(OutputStream out, String value) throws IOException {
        byte[] bytes = value.getBytes("UTF-8");
        BEIO.write32(out, bytes.length);
        out.write(bytes);
    }

    public static final byte readI8(InputStream in) throws IOException {
        return (byte)in.read();
    }

    public static final int readU8(InputStream in) throws IOException {
        return in.read();
    }

    public static final short readI16(InputStream in) throws IOException {
        return (short)BEIO.readU16(in);
    }

    public static final int readU16(InputStream in) throws IOException {
        int v = in.read() << 8;
        return v |= in.read();
    }

    public static final int readI24(InputStream in) throws IOException {
        int v = BEIO.readU24(in);
        if (v >= 0x800000) {
            return v - 0x1000000;
        }
        return v;
    }

    public static final int readU24(InputStream in) throws IOException {
        int v = in.read() << 16;
        v |= in.read() << 8;
        return v |= in.read();
    }

    public static final int readI32(InputStream in) throws IOException {
        int v = in.read() << 24;
        v |= in.read() << 16;
        v |= in.read() << 8;
        return v |= in.read();
    }

    public static final long readU32(InputStream in) throws IOException {
        return (long)BEIO.readI32(in) & 0xFFFFFFFFL;
    }

    public static final long readI64(InputStream in) throws IOException {
        long v = (long)in.read() << 56;
        v |= (long)in.read() << 48;
        v |= (long)in.read() << 40;
        v |= (long)in.read() << 32;
        v |= (long)in.read() << 24;
        v |= (long)(in.read() << 16);
        v |= (long)(in.read() << 8);
        return v |= (long)in.read();
    }

    public static final float readFloat(InputStream in) throws IOException {
        return Float.intBitsToFloat(BEIO.readI32(in));
    }

    public static final double readDouble(InputStream in) throws IOException {
        return Double.longBitsToDouble(BEIO.readI64(in));
    }

    protected static final String readStringN(InputStream in, int length) throws IOException {
        byte[] bytes = new byte[length];
        int r = BEIO.readBytes(in, bytes);
        if (r != bytes.length) {
            throw new IOException("Unexpected end of stream while reading string, expected " + bytes.length + ", got " + r + " bytes");
        }
        return new String(bytes, "UTF-8");
    }

    public static final String readString8(InputStream in) throws IOException {
        return BEIO.readStringN(in, BEIO.readU8(in));
    }

    public static final String readString16(InputStream in) throws IOException {
        return BEIO.readStringN(in, BEIO.readU16(in));
    }

    public static final String readString32(InputStream in) throws IOException {
        return BEIO.readStringN(in, BEIO.readI32(in));
    }

    public static final String readString(InputStream in, int length, int padding, String charsetName) throws IOException {
        int n;
        byte[] bytes = new byte[length];
        int r = BEIO.readBytes(in, bytes);
        if (r != length) {
            throw new IOException("Unexpected end of stream while reading string, expected " + length + ", got " + r + " bytes");
        }
        for (n = length - 1; n >= 0 && bytes[n] == padding; --n) {
        }
        return new String(bytes, 0, n + 1, charsetName);
    }

    public static final String readString(InputStream in, int length, int padding) throws IOException {
        return BEIO.readString(in, length, padding, "UTF-8");
    }

    public static final int readBytes(InputStream in, byte[] b) throws IOException {
        return BEIO.readBytes(in, b, 0, b.length);
    }

    public static final int readBytes(InputStream in, byte[] b, int offs, int len) throws IOException {
        int r;
        int todo = len;
        int got = 0;
        while (todo > 0 && (r = in.read(b, offs + got, todo)) != -1) {
            todo -= r;
            got += r;
        }
        return got;
    }

    public static final long skipBytes(InputStream in, long bytes) throws IOException {
        long r;
        long todo = bytes;
        long done = 0L;
        while (todo > 0L && (r = in.skip(todo)) != -1L) {
            todo -= r;
            done += r;
        }
        return done;
    }
}

