/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.io;

import com.github.rjeschke.neetutils.Once;
import com.github.rjeschke.neetutils.Strings;
import com.github.rjeschke.neetutils.SysUtils;
import com.github.rjeschke.neetutils.collections.Colls;
import com.github.rjeschke.neetutils.rng.RNG;
import com.github.rjeschke.neetutils.rng.RNGFactory;
import com.github.rjeschke.neetutils.rng.RNGType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class Files
implements Runnable {
    private static final ConcurrentLinkedQueue<File> TEMP_FOLDERS = new ConcurrentLinkedQueue();

    private Files() {
    }

    public static final List<File> listFiles(File parent) {
        List<File> files = Colls.list();
        Files.listFiles(parent, files);
        return files;
    }

    private static final void listFiles(File parent, List<File> files) {
        if (parent.isFile()) {
            files.add(parent);
        } else {
            File[] fs = parent.listFiles();
            if (fs != null) {
                for (File f : fs) {
                    if (f.isFile()) {
                        files.add(f);
                        continue;
                    }
                    Files.listFiles(f, files);
                }
            }
        }
    }

    public static final String getExtension(File file) {
        return Files.getExtension(file.getName());
    }

    public static final String getExtension(String filename) {
        int idx = filename.lastIndexOf(46);
        return idx != -1 ? filename.substring(idx + 1) : "";
    }

    public static final String getFullExtension(File file) {
        return Files.getFullExtension(file.getName());
    }

    public static final String getFullExtension(String filename) {
        int idx = filename.lastIndexOf(46);
        return idx != -1 ? filename.substring(idx) : "";
    }

    public static final File createUniqueTempFolder() {
        return Files.createUniqueTempFolder("neetutils", true);
    }

    public static final File createUniqueTempFolder(String prefix, boolean autoCleanup) {
        String tmp = System.getProperty("java.io.tmpdir");
        RNG rnd = RNGFactory.create(RNGType.LCG);
        for (int i = 0; i < 0x40000000; ++i) {
            File t = new File(tmp, String.format("%s-tmp-%08x", prefix, rnd.nextInt()));
            if (t.exists() || !t.mkdir()) continue;
            if (autoCleanup) {
                TEMP_FOLDERS.offer(t);
            }
            return t;
        }
        throw new RuntimeException("Could not create unique temp folder, please clean up your /tmp.");
    }

    public static final void recurseDeleteFolder(File path) {
        if (path.isDirectory()) {
            File[] files;
            for (File f : files = path.listFiles()) {
                if (f.isDirectory()) {
                    Files.recurseDeleteFolder(f);
                    continue;
                }
                f.delete();
            }
            path.delete();
        } else {
            path.delete();
        }
    }

    public static final void copy(File input, File output) throws IOException {
        try (FileInputStream in = new FileInputStream(input);
             FileOutputStream out = new FileOutputStream(output);){
            Files.copy((InputStream)in, (OutputStream)out);
        }
    }

    public static final void copy(InputStream in, File output) throws IOException {
        try (FileOutputStream out = new FileOutputStream(output);){
            Files.copy(in, (OutputStream)out);
        }
    }

    public static final void copy(File input, OutputStream out) throws IOException {
        try (FileInputStream in = new FileInputStream(input);){
            Files.copy((InputStream)in, out);
        }
    }

    public static final void copy(InputStream input, OutputStream output) throws IOException {
        int read;
        byte[] buffer = new byte[65536];
        while ((read = input.read(buffer)) != -1) {
            output.write(buffer, 0, read);
        }
    }

    public static final byte[] asBytes(String filename) throws IOException {
        return Files.asBytes(new File(filename));
    }

    public static final byte[] asBytes(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            int p;
            int r;
            byte[] buffer = new byte[(int)file.length()];
            for (p = 0; p < buffer.length && (r = fis.read(buffer, p, buffer.length - p)) != -1; p += r) {
            }
            if (p != buffer.length) {
                throw new IOException("Unexpected end of stream, expected " + buffer.length + ", got " + p + " bytes");
            }
            byte[] byArray = buffer;
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] asBytes(InputStream in) throws IOException {
        byte[] buffer = new byte[65536];
        try {
            int r;
            int p = 0;
            while ((r = in.read(buffer, p, buffer.length - p)) >= 0) {
                if ((p += r) < buffer.length) continue;
                buffer = Arrays.copyOf(buffer, buffer.length + 65536);
            }
            byte[] byArray = p != buffer.length ? Arrays.copyOf(buffer, p) : buffer;
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static final String asString(String filename, String charsetName) throws IOException {
        return new String(Files.asBytes(filename), charsetName);
    }

    public static final String asString(File file, String charsetName) throws IOException {
        return new String(Files.asBytes(file), charsetName);
    }

    public static final String asString(InputStream in, String charsetName) throws IOException {
        return new String(Files.asBytes(in), charsetName);
    }

    public static final void saveBytes(String filename, byte[] bytes) throws IOException {
        Files.saveBytes(filename, bytes, 0, bytes.length);
    }

    public static final void saveBytes(String filename, byte[] bytes, int offs, int len) throws IOException {
        Files.saveBytes(new File(filename), bytes, offs, len);
    }

    public static final void saveBytes(File file, byte[] bytes) throws IOException {
        Files.saveBytes(file, bytes, 0, bytes.length);
    }

    public static final void saveBytes(File file, byte[] bytes, int offs, int len) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(bytes, offs, len);
        }
    }

    public static final List<String> list(String pkgName) {
        URL url = SysUtils.class.getResource("/" + pkgName.replace('.', '/'));
        if (url == null) {
            return null;
        }
        if (url.getProtocol().equals("jar")) {
            return Files.getJars(url, pkgName.replace('.', '/'));
        }
        return Files.getFiles(url.getPath(), pkgName);
    }

    public static final List<String> getFilesOnClasspath() {
        ArrayList<String> ret = new ArrayList<String>();
        char sep = System.getProperty("path.separator").charAt(0);
        List<String> paths = Strings.split(System.getProperty("java.class.path"), sep);
        for (String path : paths) {
            File file = new File(path);
            if (file.isDirectory()) {
                List<File> files = Files.listFiles(file);
                int cut = file.toString().length();
                for (File f : files) {
                    ret.add(f.toString().substring(cut).replace('\\', '/'));
                }
                continue;
            }
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".jar")) continue;
            ret.addAll(Files.getJarFiles(file));
        }
        return ret;
    }

    private static final List<String> getFiles(String path, String basePackage) {
        File[] files;
        ArrayList<String> classes = new ArrayList<String>();
        String basePath = "/" + basePackage.replace('.', '/') + "/";
        File dir = new File(path).getAbsoluteFile();
        for (File f : files = dir.listFiles()) {
            String fn = f.getName();
            if (f.isDirectory()) {
                classes.addAll(Files.getFiles(new File(dir, fn).getAbsolutePath(), basePackage + "." + fn));
                continue;
            }
            if (!f.isFile()) continue;
            classes.add(basePath + fn);
        }
        return classes;
    }

    private static final List<String> getJarFiles(File file) {
        ArrayList<String> classes = new ArrayList<String>();
        try (JarFile jar = new JarFile(file);){
            Enumeration<JarEntry> j = jar.entries();
            while (j.hasMoreElements()) {
                JarEntry je = j.nextElement();
                if (je.isDirectory()) continue;
                classes.add("/" + je.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return classes;
    }

    private static final List<String> getJars(URL furl, String pkgname) {
        ArrayList<String> classes = new ArrayList<String>();
        try {
            URL url = new URL(furl.getPath());
            String f = URLDecoder.decode(url.getFile(), System.getProperty("file.encoding"));
            File dir = new File(f.substring(0, f.lastIndexOf(33)));
            try (JarFile jar = new JarFile(dir);){
                Enumeration<JarEntry> j = jar.entries();
                while (j.hasMoreElements()) {
                    JarEntry je = j.nextElement();
                    if (je.isDirectory() || !je.getName().startsWith(pkgname)) continue;
                    classes.add("/" + je.getName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return classes;
    }

    public static final String home(String path) {
        return new File(System.getProperty("user.home"), path).getAbsolutePath();
    }

    public static final File home(File path) {
        return new File(new File(System.getProperty("user.home")), path.toString());
    }

    public static final File home() {
        return new File(System.getProperty("user.home"));
    }

    public static final String cwd(String path) {
        return new File(System.getProperty("user.dir"), path).getAbsolutePath();
    }

    public static final File cwd(File path) {
        return new File(new File(System.getProperty("user.dir")), path.toString());
    }

    public static final File cwd() {
        return new File(System.getProperty("user.dir"));
    }

    public static final File normalize(File file) {
        boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
        char sep = System.getProperty("file.separator").charAt(0);
        List<String> toks = Strings.split(file.toString(), sep);
        LinkedList<String> stack = new LinkedList<String>();
        for (int i = 0; i < toks.size(); ++i) {
            String t = toks.get(i);
            if (Strings.isEmpty(t)) {
                if (i != 0 || isWindows) continue;
                stack.addLast(t);
                continue;
            }
            if (t.equals(".")) continue;
            if (t.equals("..") && !stack.isEmpty()) {
                stack.removeLast();
                continue;
            }
            stack.addLast(t);
        }
        StringBuilder sb = new StringBuilder();
        Once<String> once = Once.of("", System.getProperty("file.separator"));
        for (String s : stack) {
            sb.append(once.get());
            sb.append(s);
        }
        return new File(sb.toString());
    }

    public static final File relativeTo(File root, File child) {
        int i;
        List<String> rt = Strings.split(Files.normalize(new File(Strings.replace(root.getAbsolutePath(), '\\', '/'))).getAbsolutePath(), '/');
        List<String> ct = Strings.split(Files.normalize(new File(Strings.replace(child.getAbsolutePath(), '\\', '/'))).getAbsolutePath(), '/');
        int len = Math.min(rt.size(), ct.size());
        for (i = 0; i < len && rt.get(i).equals(ct.get(i)); ++i) {
        }
        if (i == 0) {
            return Files.normalize(child.getAbsoluteFile());
        }
        StringBuilder sb = new StringBuilder();
        while (i < rt.size()) {
            sb.append("../");
            ++i;
        }
        Once<String> once = Once.of("", "/");
        for (int n = i; n < ct.size(); ++n) {
            sb.append(once.get());
            sb.append(ct.get(n));
        }
        return new File(sb.toString());
    }

    public static final File absolute(File parent, File possibleChild) {
        return possibleChild.isAbsolute() ? possibleChild : new File(parent, possibleChild.toString());
    }

    @Override
    public void run() {
        File file;
        while ((file = TEMP_FOLDERS.poll()) != null) {
            Files.recurseDeleteFolder(file);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new Files(), "neetutils-files-cleaner"));
    }
}

