/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.io;

import com.github.rjeschke.neetutils.io.BEIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class LEIO {
    private LEIO() {
    }

    public static final void write8(OutputStream out, int value) throws IOException {
        out.write(value);
    }

    public static final void write16(OutputStream out, int value) throws IOException {
        out.write(value);
        out.write(value >> 8);
    }

    public static final void write24(OutputStream out, int value) throws IOException {
        out.write(value);
        out.write(value >> 8);
        out.write(value >> 16);
    }

    public static final void write32(OutputStream out, int value) throws IOException {
        out.write(value);
        out.write(value >> 8);
        out.write(value >> 16);
        out.write(value >> 24);
    }

    public static final void write64(OutputStream out, long value) throws IOException {
        out.write((int)value);
        out.write((int)(value >> 8));
        out.write((int)(value >> 16));
        out.write((int)(value >> 24));
        out.write((int)(value >> 32));
        out.write((int)(value >> 40));
        out.write((int)(value >> 48));
        out.write((int)(value >> 56));
    }

    public static final void writeFloat(OutputStream out, float value) throws IOException {
        LEIO.write32(out, Float.floatToIntBits(value));
    }

    public static final void writeDouble(OutputStream out, double value) throws IOException {
        LEIO.write64(out, Double.doubleToLongBits(value));
    }

    public static final void writeString(OutputStream out, String value, int length, int padding, String charsetName) throws IOException {
        BEIO.writeString(out, value, length, padding, charsetName);
    }

    public static final void writeString(OutputStream out, String value, int length, int padding) throws IOException {
        BEIO.writeString(out, value, length, padding, "UTF-8");
    }

    public static final void writeString8(OutputStream out, String value) throws IOException {
        BEIO.writeString8(out, value);
    }

    public static final void writeString16(OutputStream out, String value) throws IOException {
        byte[] bytes = value.getBytes("UTF-8");
        if (bytes.length > 65535) {
            throw new IOException("String too long (" + bytes.length + ")");
        }
        LEIO.write16(out, bytes.length);
        out.write(bytes);
    }

    public static final void writeString32(OutputStream out, String value) throws IOException {
        byte[] bytes = value.getBytes("UTF-8");
        LEIO.write32(out, bytes.length);
        out.write(bytes);
    }

    public static final byte readI8(InputStream in) throws IOException {
        return (byte)in.read();
    }

    public static final int readU8(InputStream in) throws IOException {
        return in.read();
    }

    public static final short readI16(InputStream in) throws IOException {
        return (short)LEIO.readU16(in);
    }

    public static final int readU16(InputStream in) throws IOException {
        int v = in.read();
        return v |= in.read() << 8;
    }

    public static final int readI24(InputStream in) throws IOException {
        int v = LEIO.readU24(in);
        if (v >= 0x800000) {
            return v - 0x1000000;
        }
        return v;
    }

    public static final int readU24(InputStream in) throws IOException {
        int v = in.read();
        v |= in.read() << 8;
        return v |= in.read() << 16;
    }

    public static final int readI32(InputStream in) throws IOException {
        int v = in.read();
        v |= in.read() << 8;
        v |= in.read() << 16;
        return v |= in.read() << 24;
    }

    public static final long readU32(InputStream in) throws IOException {
        return (long)LEIO.readI32(in) & 0xFFFFFFFFL;
    }

    public static final long readI64(InputStream in) throws IOException {
        long v = in.read();
        v |= (long)(in.read() << 8);
        v |= (long)(in.read() << 16);
        v |= (long)in.read() << 24;
        v |= (long)in.read() << 32;
        v |= (long)in.read() << 40;
        v |= (long)in.read() << 48;
        return v |= (long)in.read() << 56;
    }

    public static final float readFloat(InputStream in) throws IOException {
        return Float.intBitsToFloat(LEIO.readI32(in));
    }

    public static final double readDouble(InputStream in) throws IOException {
        return Double.longBitsToDouble(LEIO.readI64(in));
    }

    public static final String readString8(InputStream in) throws IOException {
        return BEIO.readStringN(in, LEIO.readU8(in));
    }

    public static final String readString16(InputStream in) throws IOException {
        return BEIO.readStringN(in, LEIO.readU16(in));
    }

    public static final String readString32(InputStream in) throws IOException {
        return BEIO.readStringN(in, LEIO.readI32(in));
    }

    public static final String readString(InputStream in, int length, int padding, String charsetName) throws IOException {
        return BEIO.readString(in, length, padding, charsetName);
    }

    public static final String readString(InputStream in, int length, int padding) throws IOException {
        return BEIO.readString(in, length, padding, "UTF-8");
    }

    public static final int readBytes(InputStream in, byte[] b) throws IOException {
        return BEIO.readBytes(in, b, 0, b.length);
    }

    public static final int readBytes(InputStream in, byte[] b, int offs, int len) throws IOException {
        return BEIO.readBytes(in, b, offs, len);
    }

    public static final long skipBytes(InputStream in, long bytes) throws IOException {
        return BEIO.skipBytes(in, bytes);
    }
}

