/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.io;

import com.github.rjeschke.neetutils.WrappedCheckedException;
import com.github.rjeschke.neetutils.iterables.AbstractXIterable;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LineReaderIterator
extends AbstractXIterable<String>
implements AutoCloseable {
    final BufferedReader in;
    boolean closed = false;
    volatile boolean iteratorInUse = false;
    String current;

    public LineReaderIterator(BufferedReader in) {
        this.in = in;
        this.current = this.read();
    }

    String read() {
        if (this.closed) {
            this.current = null;
            return null;
        }
        try {
            this.current = this.in.readLine();
            if (this.current == null) {
                this.in.close();
                this.closed = true;
            }
        }
        catch (IOException e) {
            this.current = null;
            try {
                this.in.close();
                this.closed = true;
            }
            catch (IOException e1) {
                throw new WrappedCheckedException(e);
            }
        }
        return this.current;
    }

    @Override
    public synchronized Iterator<String> iterator() {
        if (this.iteratorInUse) {
            throw new IllegalStateException("An iterator is already in use");
        }
        return new StreamIterator(this);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.closed = true;
        this.current = null;
    }

    private static class StreamIterator
    implements Iterator<String> {
        final LineReaderIterator lri;

        public StreamIterator(LineReaderIterator lri) {
            this.lri = lri;
        }

        @Override
        public boolean hasNext() {
            return this.lri.current != null;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Trying to read past end of stream");
            }
            String ret = this.lri.current;
            this.lri.read();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can not remove characters from an InputStream");
        }
    }
}

