/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.iterables;

import com.github.rjeschke.neetutils.iterables.AbstractXIterable;
import com.github.rjeschke.neetutils.math.Numbers;
import java.util.Iterator;

public class CharacterIterator
extends AbstractXIterable<Character> {
    private final String value;

    public CharacterIterator(String value) {
        this.value = value;
    }

    public static final CharacterIterator of(String value) {
        return new CharacterIterator(value);
    }

    @Override
    public Iterator<Character> iterator() {
        return new XIterator(this.value);
    }

    private static final class XIterator
    implements Iterator<Character> {
        private final String value;
        private int position = 0;

        public XIterator(String value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.value.length();
        }

        @Override
        public Character next() {
            return Numbers.characterOf(this.value.charAt(this.position++));
        }

        @Override
        public void remove() {
            throw new IllegalStateException("CharacterIterator is read-only.");
        }
    }
}

