/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.iterables;

import com.github.rjeschke.neetutils.iterables.AbstractXIterable;
import com.github.rjeschke.neetutils.iterables.Collector;
import java.util.Iterator;
import java.util.NoSuchElementException;

class XIterableCollect<A, B>
extends AbstractXIterable<B> {
    private final Iterable<? extends A> iterable;
    private final Collector<? super A, B> collector;

    public XIterableCollect(Iterable<? extends A> iterable, Collector<? super A, B> collector) {
        this.iterable = iterable;
        this.collector = collector;
    }

    @Override
    public Iterator<B> iterator() {
        return new XIterator<A, B>(this.iterable.iterator(), this.collector);
    }

    static final class XIterator<A, B>
    implements Iterator<B> {
        private final Iterator<? extends A> iterator;
        private final Collector<? super A, B> collector;

        public XIterator(Iterator<? extends A> iterator, Collector<? super A, B> collector) {
            this.iterator = iterator;
            this.collector = collector;
            this.collector.init();
        }

        @Override
        public boolean hasNext() {
            if (!this.collector.hasElement) {
                this.collector.collect(this.iterator);
            }
            return this.collector.hasElement;
        }

        @Override
        public B next() {
            if (!this.collector.hasElement) {
                throw new NoSuchElementException();
            }
            this.collector.hasElement = false;
            return this.collector.value;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("XIterators are read-only.");
        }
    }
}

