/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.iterables;

import com.github.rjeschke.neetutils.fn.FnCombine;
import com.github.rjeschke.neetutils.iterables.AbstractXIterable;
import java.util.Iterator;

class XIterableZipWith<A, B, C>
extends AbstractXIterable<C> {
    private final Iterable<A> iterableA;
    private final Iterable<B> iterableB;
    private final FnCombine<? super A, ? super B, C> combine;

    public XIterableZipWith(Iterable<A> iterableA, Iterable<B> iterableB, FnCombine<? super A, ? super B, C> combine) {
        this.iterableA = iterableA;
        this.iterableB = iterableB;
        this.combine = combine;
    }

    @Override
    public Iterator<C> iterator() {
        return new XIterator<A, B, C>(this.iterableA.iterator(), this.iterableB.iterator(), this.combine);
    }

    private static final class XIterator<A, B, C>
    implements Iterator<C> {
        private final Iterator<A> iteratorA;
        private final Iterator<B> iteratorB;
        private final FnCombine<? super A, ? super B, C> combine;

        public XIterator(Iterator<A> iteratorA, Iterator<B> iteratorB, FnCombine<? super A, ? super B, C> combine) {
            this.iteratorA = iteratorA;
            this.iteratorB = iteratorB;
            this.combine = combine;
        }

        @Override
        public boolean hasNext() {
            return this.iteratorA.hasNext() && this.iteratorB.hasNext();
        }

        @Override
        public C next() {
            return this.combine.applyCombine(this.iteratorA.next(), this.iteratorB.next());
        }

        @Override
        public void remove() {
            throw new IllegalStateException("XIterators are read-only.");
        }
    }
}

