/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.lists;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.RandomAccess;

public class UshortList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3837395301685776241L;
    private static final transient int INIT_SIZE = 16;
    private transient short[] data;
    private int size;
    private transient int maxSize;

    public UshortList() {
        this(16);
    }

    public UshortList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity must not be less than 0");
        }
        this.maxSize = initialCapacity;
        this.size = 0;
        this.data = new short[initialCapacity];
    }

    public static UshortList fromArray(int ... values) {
        UshortList list = new UshortList(values.length);
        for (int i = 0; i < values.length; ++i) {
            list.data[i] = (short)values[i];
        }
        list.size = values.length;
        return list;
    }

    public static UshortList fromArray(short ... values) {
        UshortList list = new UshortList(values.length);
        System.arraycopy(values, 0, list.data, 0, values.length);
        list.size = values.length;
        return list;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    public void trimToSize() {
        if (this.maxSize > this.size) {
            this.maxSize = this.size;
            this.data = Arrays.copyOf(this.data, this.size);
        }
    }

    public int add(int v) {
        this.grow(this.size + 1);
        this.data[this.size++] = (short)v;
        return v;
    }

    public int add(int index, int v) {
        if (index == this.size) {
            return this.add(v);
        }
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.grow(this.size + 1);
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = (short)v;
        ++this.size;
        return v;
    }

    public int remove(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        short old = this.data[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.data, index + 1, this.data, index, this.size - index);
        }
        return old & 0xFFFF;
    }

    public int set(int index, int v) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.data[index] = (short)v;
        return v;
    }

    public int get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[index] & 0xFFFF;
    }

    public short[] toArray() {
        return Arrays.copyOf(this.data, this.size);
    }

    public boolean contains(int v) {
        return this.indexOf(v) != -1;
    }

    public int indexOf(int v) {
        short c = (short)v;
        for (int i = 0; i < this.size; ++i) {
            if (c != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int v) {
        short c = (short)v;
        for (int i = this.size - 1; i >= 0; --i) {
            if (c != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        if (this.size > 0) {
            sb.append(this.data[0] & 0xFFFF);
            for (int i = 1; i < this.size; ++i) {
                sb.append(',');
                sb.append(this.data[i] & 0xFFFF);
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        int hash = 1;
        for (int i = 0; i < this.size; ++i) {
            hash = hash * 31 + this.data[i];
        }
        return hash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof UshortList)) {
            return false;
        }
        UshortList list = (UshortList)other;
        if (list.size != this.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == list.data[i]) continue;
            return false;
        }
        return true;
    }

    public UshortList clone() {
        UshortList list = new UshortList(this.size);
        list.size = this.size;
        System.arraycopy(this.data, 0, list.data, 0, this.size);
        return list;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            out.writeShort(this.data[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.maxSize = this.size;
        this.data = new short[this.maxSize];
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = in.readShort();
        }
    }

    private void grow(int required) {
        if (required > this.maxSize) {
            this.maxSize = (this.maxSize * 3 >>> 1) + 1;
            this.data = Arrays.copyOf(this.data, this.maxSize);
        }
    }
}

