/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.math;

public final class NMath {
    public static final double INV_LOG_2 = 1.0 / Math.log(2.0);
    public static final double LOG_2 = Math.log(2.0);
    public static final float INV_LOG_2f = (float)(1.0 / Math.log(2.0));
    public static final float LOG_2f = (float)Math.log(2.0);
    public static final double U_Y = 1.0E24;
    public static final double U_Z = 1.0E21;
    public static final double U_E = 1.0E18;
    public static final double U_P = 1.0E15;
    public static final double U_T = 1.0E12;
    public static final double U_G = 1.0E9;
    public static final double U_M = 1000000.0;
    public static final double U_k = 1000.0;
    public static final double U_h = 100.0;
    public static final double U_da = 10.0;
    public static final double U_d = 0.1;
    public static final double U_c = 0.01;
    public static final double U_m = 0.001;
    public static final double U_u = 1.0E-6;
    public static final double U_n = 1.0E-9;
    public static final double U_p = 1.0E-12;
    public static final double U_f = 1.0E-15;
    public static final double U_a = 1.0E-18;
    public static final double U_z = 1.0E-21;
    public static final double U_y = 1.0E-24;

    private NMath() {
    }

    public static final int clamp(int x, int min, int max) {
        return Math.max(min, Math.min(max, x));
    }

    public static final float clamp(float x, float min, float max) {
        return Math.max(min, Math.min(max, x));
    }

    public static final double clamp(double x, double min, double max) {
        return Math.max(min, Math.min(max, x));
    }

    public static final float lerp(float a, float b, float f) {
        return a + (b - a) * f;
    }

    public static final double lerp(double a, double b, double f) {
        return a + (b - a) * f;
    }

    public static final float normalize(float v) {
        return Math.abs(v) < Float.MIN_NORMAL ? 0.0f : v;
    }

    public static final double normalize(double v) {
        return Math.abs(v) < Double.MIN_NORMAL ? 0.0 : v;
    }

    public static final int nextPow2(int value) {
        return 1 << (int)Math.ceil(Math.log(value) * INV_LOG_2);
    }

    public static final float step(float edge, float x) {
        return x < edge ? 0.0f : 1.0f;
    }

    public static final double step(double edge, double x) {
        return x < edge ? 0.0 : 1.0;
    }

    public static final float smoothstep(float edge0, float edge1, float x) {
        float y = NMath.saturate((x - edge0) / (edge1 - edge0));
        return y * y * (3.0f - 2.0f * y);
    }

    public static final double smoothstep(double edge0, double edge1, double x) {
        double y = NMath.saturate((x - edge0) / (edge1 - edge0));
        return y * y * (3.0 - 2.0 * y);
    }

    public static final float saturate(float x) {
        return Math.max(0.0f, Math.min(1.0f, x));
    }

    public static final double saturate(double x) {
        return Math.max(0.0, Math.min(1.0, x));
    }

    public static final float fract(float x) {
        return Math.min(x - (float)Math.floor(x), 0.99999994f);
    }

    public static final double fract(double x) {
        return Math.min(x - Math.floor(x), 0.9999999999999991);
    }

    public static final float sinc(float x) {
        if (x != 0.0f) {
            float xpi = (float)Math.PI * x;
            return (float)Math.sin(xpi) / xpi;
        }
        return 1.0f;
    }

    public static final double i0(double x) {
        double x2;
        double f = 1.0;
        double xc = x2 = x * x * 0.25;
        double v = 1.0 + x2;
        for (int i = 2; i < 100; ++i) {
            double a = (xc *= x2) / ((f *= (double)i) * f);
            v += a;
            if (a < 1.0E-20) break;
        }
        return v;
    }

    public static final double sinc(double x) {
        if (x != 0.0) {
            double xpi = Math.PI * x;
            return Math.sin(xpi) / xpi;
        }
        return 1.0;
    }

    public static final long rol64(long value, int bits) {
        int b = bits & 0x3F;
        if (b == 0) {
            return value;
        }
        return value << b | value >>> 64 - b;
    }

    public static final long ror64(long value, int bits) {
        int b = bits & 0x3F;
        if (b == 0) {
            return value;
        }
        return value >>> b | value << 64 - b;
    }

    public static final int rol32(int value, int bits) {
        int b = bits & 0x1F;
        if (b == 0) {
            return value;
        }
        return value << b | value >>> 32 - b;
    }

    public static final int ror32(int value, int bits) {
        int b = bits & 0x1F;
        if (b == 0) {
            return value;
        }
        return value >>> b | value << 32 - b;
    }

    public static final int rol24(int value, int bits) {
        int b = Math.abs(bits % 24);
        if (b == 0) {
            return value;
        }
        int v = value & 0xFFFFFF;
        return (v >> b | v << 24 - b) & 0xFFFFFF;
    }

    public static final int ror24(int value, int bits) {
        int b = Math.abs(bits % 24);
        if (b == 0) {
            return value;
        }
        int v = value & 0xFFFFFF;
        return (v >> b | v << 24 - b) & 0xFFFFFF;
    }

    public static final int rol16(int value, int bits) {
        int b = bits & 0xF;
        if (b == 0) {
            return value;
        }
        int v = value & 0xFFFF;
        return (v << b | v >> 16 - b) & 0xFFFF;
    }

    public static final int ror16(int value, int bits) {
        int b = bits & 0xF;
        if (b == 0) {
            return value;
        }
        int v = value & 0xFFFF;
        return (v >> b | v << 16 - b) & 0xFFFF;
    }

    public static final int rol8(int value, int bits) {
        int b = bits & 7;
        if (b == 0) {
            return value;
        }
        int v = value & 0xFF;
        return (v << b | v >> 8 - b) & 0xFF;
    }

    public static final int ror8(int value, int bits) {
        int b = bits & 7;
        if (b == 0) {
            return value;
        }
        int v = value & 0xFF;
        return (v >> b | v << 8 - b) & 0xFF;
    }

    public static final double getButterworthFactor(int n, int k) {
        return -2.0 * Math.cos((2.0 * (double)k + (double)n - 1.0) / (double)(2 * n) * Math.PI);
    }

    public static final double log2(double x) {
        return Math.log(x) * INV_LOG_2;
    }

    public static final double exp2(double x) {
        return Math.pow(2.0, x);
    }

    public static final float log2(float x) {
        return (float)(Math.log(x) * INV_LOG_2);
    }

    public static final float exp2(float x) {
        return (float)Math.pow(2.0, x);
    }

    public static final boolean doubleEquals(double a, double b, double epsilon) {
        return Math.abs(a - b) <= epsilon;
    }

    public static final boolean floatEquals(float a, float b, float epsilon) {
        return Math.abs(a - b) <= epsilon;
    }

    public static final byte min(byte[] xs) {
        byte v = 127;
        for (int i = 0; i < xs.length; ++i) {
            v = (byte)Math.min(xs[i], v);
        }
        return v;
    }

    public static final byte min(byte[] xs, int offset, int length) {
        byte v = 127;
        for (int i = offset; i < offset + length; ++i) {
            v = (byte)Math.min(xs[i], v);
        }
        return v;
    }

    public static final byte max(byte[] xs) {
        byte v = -128;
        for (int i = 0; i < xs.length; ++i) {
            v = (byte)Math.max(xs[i], v);
        }
        return v;
    }

    public static final byte max(byte[] xs, int offset, int length) {
        byte v = -128;
        for (int i = offset; i < offset + length; ++i) {
            v = (byte)Math.max(xs[i], v);
        }
        return v;
    }

    public static final short min(short[] xs) {
        short v = Short.MAX_VALUE;
        for (int i = 0; i < xs.length; ++i) {
            v = (short)Math.min(xs[i], v);
        }
        return v;
    }

    public static final short min(short[] xs, int offset, int length) {
        short v = Short.MAX_VALUE;
        for (int i = offset; i < offset + length; ++i) {
            v = (short)Math.min(xs[i], v);
        }
        return v;
    }

    public static final short max(short[] xs) {
        short v = Short.MIN_VALUE;
        for (int i = 0; i < xs.length; ++i) {
            v = (short)Math.max(xs[i], v);
        }
        return v;
    }

    public static final short max(short[] xs, int offset, int length) {
        short v = Short.MIN_VALUE;
        for (int i = offset; i < offset + length; ++i) {
            v = (short)Math.max(xs[i], v);
        }
        return v;
    }

    public static final int min(int[] xs) {
        int v = Integer.MAX_VALUE;
        for (int i = 0; i < xs.length; ++i) {
            v = Math.min(xs[i], v);
        }
        return v;
    }

    public static final int min(int[] xs, int offset, int length) {
        int v = Integer.MAX_VALUE;
        for (int i = offset; i < offset + length; ++i) {
            v = Math.min(xs[i], v);
        }
        return v;
    }

    public static final int max(int[] xs) {
        int v = Integer.MIN_VALUE;
        for (int i = 0; i < xs.length; ++i) {
            v = Math.max(xs[i], v);
        }
        return v;
    }

    public static final int max(int[] xs, int offset, int length) {
        int v = Integer.MIN_VALUE;
        for (int i = offset; i < offset + length; ++i) {
            v = Math.max(xs[i], v);
        }
        return v;
    }

    public static final long min(long[] xs) {
        long v = Long.MAX_VALUE;
        for (int i = 0; i < xs.length; ++i) {
            v = Math.min(xs[i], v);
        }
        return v;
    }

    public static final long min(long[] xs, int offset, int length) {
        long v = Long.MAX_VALUE;
        for (int i = offset; i < offset + length; ++i) {
            v = Math.min(xs[i], v);
        }
        return v;
    }

    public static final long max(long[] xs) {
        long v = Long.MIN_VALUE;
        for (int i = 0; i < xs.length; ++i) {
            v = Math.max(xs[i], v);
        }
        return v;
    }

    public static final long max(long[] xs, int offset, int length) {
        long v = Long.MIN_VALUE;
        for (int i = offset; i < offset + length; ++i) {
            v = Math.max(xs[i], v);
        }
        return v;
    }

    public static final float min(float[] xs) {
        float v = Float.MAX_VALUE;
        for (int i = 0; i < xs.length; ++i) {
            v = Math.min(xs[i], v);
        }
        return v;
    }

    public static final float min(float[] xs, int offset, int length) {
        float v = Float.MAX_VALUE;
        for (int i = offset; i < offset + length; ++i) {
            v = Math.min(xs[i], v);
        }
        return v;
    }

    public static final float max(float[] xs) {
        float v = -3.4028235E38f;
        for (int i = 0; i < xs.length; ++i) {
            v = Math.max(xs[i], v);
        }
        return v;
    }

    public static final float max(float[] xs, int offset, int length) {
        float v = -3.4028235E38f;
        for (int i = offset; i < offset + length; ++i) {
            v = Math.max(xs[i], v);
        }
        return v;
    }

    public static final float amin(float[] xs) {
        float v = Float.MAX_VALUE;
        for (int i = 0; i < xs.length; ++i) {
            v = Math.min(Math.abs(xs[i]), v);
        }
        return v;
    }

    public static final float amin(float[] xs, int offset, int length) {
        float v = Float.MAX_VALUE;
        for (int i = offset; i < offset + length; ++i) {
            v = Math.min(Math.abs(xs[i]), v);
        }
        return v;
    }

    public static final float amax(float[] xs) {
        float v = 0.0f;
        for (int i = 0; i < xs.length; ++i) {
            v = Math.max(Math.abs(xs[i]), v);
        }
        return v;
    }

    public static final float amax(float[] xs, int offset, int length) {
        float v = 0.0f;
        for (int i = offset; i < offset + length; ++i) {
            v = Math.max(Math.abs(xs[i]), v);
        }
        return v;
    }

    public static final float[] add(float[] xs, float y) {
        int i = 0;
        while (i < xs.length) {
            int n = i++;
            xs[n] = xs[n] + y;
        }
        return xs;
    }

    public static final float[] add(float[] xs, int offset, int length, float y) {
        int i = offset;
        while (i < offset + length) {
            int n = i++;
            xs[n] = xs[n] + y;
        }
        return xs;
    }

    public static final float[] sub(float[] xs, float y) {
        int i = 0;
        while (i < xs.length) {
            int n = i++;
            xs[n] = xs[n] - y;
        }
        return xs;
    }

    public static final float[] sub(float[] xs, int offset, int length, float y) {
        int i = offset;
        while (i < offset + length) {
            int n = i++;
            xs[n] = xs[n] - y;
        }
        return xs;
    }

    public static final float[] mul(float[] xs, float y) {
        int i = 0;
        while (i < xs.length) {
            int n = i++;
            xs[n] = xs[n] * y;
        }
        return xs;
    }

    public static final float[] mul(float[] xs, int offset, int length, float y) {
        int i = offset;
        while (i < offset + length) {
            int n = i++;
            xs[n] = xs[n] * y;
        }
        return xs;
    }

    public static final float[] div(float[] xs, float y) {
        int i = 0;
        while (i < xs.length) {
            int n = i++;
            xs[n] = xs[n] / y;
        }
        return xs;
    }

    public static final float[] div(float[] xs, int offset, int length, float y) {
        int i = offset;
        while (i < offset + length) {
            int n = i++;
            xs[n] = xs[n] / y;
        }
        return xs;
    }

    public static final float[] pow(float[] xs, float y) {
        for (int i = 0; i < xs.length; ++i) {
            xs[i] = (float)Math.pow(xs[i], y);
        }
        return xs;
    }

    public static final float[] pow(float[] xs, int offset, int length, float y) {
        for (int i = offset; i < offset + length; ++i) {
            xs[i] = (float)Math.pow(xs[i], y);
        }
        return xs;
    }

    public static final int square(int x) {
        return x * x;
    }

    public static final long square(long x) {
        return x * x;
    }

    public static final float square(float x) {
        return x * x;
    }

    public static final double square(double x) {
        return x * x;
    }

    public static final float[] square(float[] xs) {
        for (int i = 0; i < xs.length; ++i) {
            int n = i;
            xs[n] = xs[n] * xs[i];
        }
        return xs;
    }

    public static final float[] square(float[] xs, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            int n = i;
            xs[n] = xs[n] * xs[i];
        }
        return xs;
    }

    public static final float[] sqrt(float[] xs) {
        for (int i = 0; i < xs.length; ++i) {
            xs[i] = (float)Math.sqrt(xs[i]);
        }
        return xs;
    }

    public static final float[] sqrt(float[] xs, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            xs[i] = (float)Math.sqrt(xs[i]);
        }
        return xs;
    }

    public static final float sum(float[] xs) {
        float sum = 0.0f;
        for (int i = 0; i < xs.length; ++i) {
            sum += xs[i];
        }
        return sum;
    }

    public static final float sum(float[] xs, int offset, int length) {
        float sum = 0.0f;
        for (int i = offset; i < offset + length; ++i) {
            sum += xs[i];
        }
        return sum;
    }

    public static final double min(double[] xs) {
        double v = Double.MAX_VALUE;
        for (int i = 0; i < xs.length; ++i) {
            v = Math.min(xs[i], v);
        }
        return v;
    }

    public static final double min(double[] xs, int offset, int length) {
        double v = Double.MAX_VALUE;
        for (int i = offset; i < offset + length; ++i) {
            v = Math.min(xs[i], v);
        }
        return v;
    }

    public static final double max(double[] xs) {
        double v = -1.7976931348623157E308;
        for (int i = 0; i < xs.length; ++i) {
            v = Math.max(xs[i], v);
        }
        return v;
    }

    public static final double max(double[] xs, int offset, int length) {
        double v = -1.7976931348623157E308;
        for (int i = offset; i < offset + length; ++i) {
            v = Math.max(xs[i], v);
        }
        return v;
    }

    public static final double amin(double[] xs) {
        double v = Double.MAX_VALUE;
        for (int i = 0; i < xs.length; ++i) {
            v = Math.min(Math.abs(xs[i]), v);
        }
        return v;
    }

    public static final double amin(double[] xs, int offset, int length) {
        double v = Double.MAX_VALUE;
        for (int i = offset; i < offset + length; ++i) {
            v = Math.min(Math.abs(xs[i]), v);
        }
        return v;
    }

    public static final double amax(double[] xs) {
        double v = 0.0;
        for (int i = 0; i < xs.length; ++i) {
            v = Math.max(Math.abs(xs[i]), v);
        }
        return v;
    }

    public static final double amax(double[] xs, int offset, int length) {
        double v = 0.0;
        for (int i = offset; i < offset + length; ++i) {
            v = Math.max(Math.abs(xs[i]), v);
        }
        return v;
    }

    public static final double[] add(double[] xs, double y) {
        int i = 0;
        while (i < xs.length) {
            int n = i++;
            xs[n] = xs[n] + y;
        }
        return xs;
    }

    public static final double[] add(double[] xs, int offset, int length, double y) {
        int i = offset;
        while (i < offset + length) {
            int n = i++;
            xs[n] = xs[n] + y;
        }
        return xs;
    }

    public static final double[] sub(double[] xs, double y) {
        int i = 0;
        while (i < xs.length) {
            int n = i++;
            xs[n] = xs[n] - y;
        }
        return xs;
    }

    public static final double[] sub(double[] xs, int offset, int length, double y) {
        int i = offset;
        while (i < offset + length) {
            int n = i++;
            xs[n] = xs[n] - y;
        }
        return xs;
    }

    public static final double[] mul(double[] xs, double y) {
        int i = 0;
        while (i < xs.length) {
            int n = i++;
            xs[n] = xs[n] * y;
        }
        return xs;
    }

    public static final double[] mul(double[] xs, int offset, int length, double y) {
        int i = offset;
        while (i < offset + length) {
            int n = i++;
            xs[n] = xs[n] * y;
        }
        return xs;
    }

    public static final double[] div(double[] xs, double y) {
        int i = 0;
        while (i < xs.length) {
            int n = i++;
            xs[n] = xs[n] / y;
        }
        return xs;
    }

    public static final double[] div(double[] xs, int offset, int length, double y) {
        int i = offset;
        while (i < offset + length) {
            int n = i++;
            xs[n] = xs[n] / y;
        }
        return xs;
    }

    public static final double[] pow(double[] xs, double y) {
        for (int i = 0; i < xs.length; ++i) {
            xs[i] = Math.pow(xs[i], y);
        }
        return xs;
    }

    public static final double[] pow(double[] xs, int offset, int length, double y) {
        for (int i = offset; i < offset + length; ++i) {
            xs[i] = Math.pow(xs[i], y);
        }
        return xs;
    }

    public static final double[] square(double[] xs) {
        for (int i = 0; i < xs.length; ++i) {
            int n = i;
            xs[n] = xs[n] * xs[i];
        }
        return xs;
    }

    public static final double[] square(double[] xs, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            int n = i;
            xs[n] = xs[n] * xs[i];
        }
        return xs;
    }

    public static final double[] sqrt(double[] xs) {
        for (int i = 0; i < xs.length; ++i) {
            xs[i] = Math.sqrt(xs[i]);
        }
        return xs;
    }

    public static final double[] sqrt(double[] xs, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            xs[i] = Math.sqrt(xs[i]);
        }
        return xs;
    }

    public static final double sum(double[] xs) {
        double sum = 0.0;
        for (int i = 0; i < xs.length; ++i) {
            sum += xs[i];
        }
        return sum;
    }

    public static final double sum(double[] xs, int offset, int length) {
        double sum = 0.0;
        for (int i = offset; i < offset + length; ++i) {
            sum += xs[i];
        }
        return sum;
    }

    public static int wrap(int x, int max) {
        int w = x % max;
        return w < 0 ? w + max : w;
    }

    public static long wrap(long x, long max) {
        long w = x % max;
        return w < 0L ? w + max : w;
    }

    public static float wrap(float x, float max) {
        float w = x % max;
        return w < 0.0f ? w + max : w;
    }

    public static double wrap(double x, double max) {
        double w = x % max;
        return w < 0.0 ? w + max : w;
    }

    public static float wrap1(float x) {
        return x - (float)Math.floor(x);
    }

    public static double wrap1(double x) {
        return x - Math.floor(x);
    }

    public static float round(float x) {
        return (float)(x < 0.0f ? Math.ceil((double)x - 0.5) : Math.floor((double)x + 0.5));
    }

    public static double round(double x) {
        return x < 0.0 ? Math.ceil(x - 0.5) : Math.floor(x + 0.5);
    }
}

