/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.rng;

import com.github.rjeschke.neetutils.rng.RNG;
import com.github.rjeschke.neetutils.rng.RNGType;
import com.github.rjeschke.neetutils.rng.RndCMWC;
import com.github.rjeschke.neetutils.rng.RndGFSR;
import com.github.rjeschke.neetutils.rng.RndLCG;
import com.github.rjeschke.neetutils.rng.RndLCG32;

public final class RNGFactory {
    private RNGFactory() {
    }

    public static final long defaultSeed() {
        return System.nanoTime() + Thread.currentThread().getId();
    }

    public static final RNG create(RNGType type) {
        return RNGFactory.create(type, RNGFactory.defaultSeed());
    }

    public static final RNG create(RNGType type, long seed) {
        switch (type) {
            case LCG: {
                return new RndLCG(seed);
            }
            case LCG32: {
                return new RndLCG32(seed);
            }
            case GFSR: {
                return new RndGFSR(seed);
            }
            case CMWC: {
                return new RndCMWC(seed);
            }
        }
        throw new IllegalArgumentException("This should never happen");
    }
}

