/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.vectors;

import com.github.rjeschke.neetutils.vectors.Vector3d;
import com.github.rjeschke.neetutils.vectors.Vector4d;

public class Matrix4x4d {
    public static final int M00 = 0;
    public static final int M01 = 4;
    public static final int M02 = 8;
    public static final int M03 = 12;
    public static final int M10 = 1;
    public static final int M11 = 5;
    public static final int M12 = 9;
    public static final int M13 = 13;
    public static final int M20 = 2;
    public static final int M21 = 6;
    public static final int M22 = 10;
    public static final int M23 = 14;
    public static final int M30 = 3;
    public static final int M31 = 7;
    public static final int M32 = 11;
    public static final int M33 = 15;
    protected final double[] data = new double[16];
    public static final Matrix4x4d IDENTITY = Matrix4x4d.identity();

    private Matrix4x4d() {
    }

    public Matrix4x4d(double[] m, boolean transpose) {
        if (transpose) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    this.data[y * 4 + x] = m[x * 4 + y];
                }
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                this.data[i] = m[i];
            }
        }
    }

    public Matrix4x4d(double[] m) {
        this(m, false);
    }

    public Matrix4x4d(double[] m, int offset) {
        System.arraycopy(m, offset, this.data, 0, 16);
    }

    private static Matrix4x4d identity() {
        Matrix4x4d mat = new Matrix4x4d();
        mat.data[0] = 1.0;
        mat.data[5] = 1.0;
        mat.data[10] = 1.0;
        mat.data[15] = 1.0;
        return mat;
    }

    public double determinant() {
        double s0 = this.data[0] * this.data[5] - this.data[4] * this.data[1];
        double s1 = this.data[0] * this.data[9] - this.data[8] * this.data[1];
        double s2 = this.data[0] * this.data[13] - this.data[12] * this.data[1];
        double s3 = this.data[4] * this.data[9] - this.data[8] * this.data[13];
        double s4 = this.data[4] * this.data[13] - this.data[12] * this.data[5];
        double s5 = this.data[8] * this.data[13] - this.data[12] * this.data[9];
        double c5 = this.data[10] * this.data[15] - this.data[14] * this.data[11];
        double c4 = this.data[6] * this.data[15] - this.data[14] * this.data[7];
        double c3 = this.data[6] * this.data[11] - this.data[10] * this.data[7];
        double c2 = this.data[2] * this.data[15] - this.data[14] * this.data[3];
        double c1 = this.data[2] * this.data[11] - this.data[10] * this.data[3];
        double c0 = this.data[2] * this.data[7] - this.data[6] * this.data[3];
        return s0 * c5 - s1 * c4 + s2 * c3 + s3 * c2 - s4 * c1 + s5 * c0;
    }

    public Matrix4x4d adjugate() {
        double s0 = this.data[0] * this.data[5] - this.data[4] * this.data[1];
        double s1 = this.data[0] * this.data[9] - this.data[8] * this.data[1];
        double s2 = this.data[0] * this.data[13] - this.data[12] * this.data[1];
        double s3 = this.data[4] * this.data[9] - this.data[8] * this.data[13];
        double s4 = this.data[4] * this.data[13] - this.data[12] * this.data[5];
        double s5 = this.data[8] * this.data[13] - this.data[12] * this.data[9];
        double c5 = this.data[10] * this.data[15] - this.data[14] * this.data[11];
        double c4 = this.data[6] * this.data[15] - this.data[14] * this.data[7];
        double c3 = this.data[6] * this.data[11] - this.data[10] * this.data[7];
        double c2 = this.data[2] * this.data[15] - this.data[14] * this.data[3];
        double c1 = this.data[2] * this.data[11] - this.data[10] * this.data[3];
        double c0 = this.data[2] * this.data[7] - this.data[6] * this.data[3];
        Matrix4x4d mat = new Matrix4x4d();
        mat.data[0] = this.data[5] * c5 - this.data[9] * c4 + this.data[13] * c3;
        mat.data[4] = -this.data[4] * c5 + this.data[8] * c4 - this.data[12] * c3;
        mat.data[8] = this.data[7] * s5 - this.data[11] * s4 + this.data[15] * s3;
        mat.data[12] = -this.data[6] * s5 + this.data[10] * s4 - this.data[14] * s3;
        mat.data[1] = -this.data[1] * c5 + this.data[9] * c2 - this.data[13] * c1;
        mat.data[5] = this.data[0] * c5 - this.data[8] * c2 + this.data[12] * c1;
        mat.data[9] = -this.data[3] * s5 + this.data[11] * s2 - this.data[15] * s1;
        mat.data[13] = this.data[2] * s5 - this.data[10] * s2 + this.data[14] * s1;
        mat.data[2] = this.data[1] * c4 - this.data[5] * c2 + this.data[13] * c0;
        mat.data[6] = -this.data[0] * c4 + this.data[4] * c2 - this.data[12] * c0;
        mat.data[10] = this.data[3] * s4 - this.data[7] * s2 + this.data[15] * s0;
        mat.data[14] = -this.data[2] * s4 + this.data[6] * s2 - this.data[14] * s0;
        mat.data[3] = -this.data[1] * c3 + this.data[5] * c1 - this.data[9] * c0;
        mat.data[7] = this.data[0] * c3 - this.data[4] * c1 + this.data[8] * c0;
        mat.data[11] = -this.data[3] * s3 + this.data[7] * s1 - this.data[11] * s0;
        mat.data[15] = this.data[2] * s3 - this.data[6] * s1 + this.data[10] * s0;
        return mat;
    }

    public Matrix4x4d inverse() {
        double s0 = this.data[0] * this.data[5] - this.data[4] * this.data[1];
        double s1 = this.data[0] * this.data[9] - this.data[8] * this.data[1];
        double s2 = this.data[0] * this.data[13] - this.data[12] * this.data[1];
        double s3 = this.data[4] * this.data[9] - this.data[8] * this.data[13];
        double s4 = this.data[4] * this.data[13] - this.data[12] * this.data[5];
        double s5 = this.data[8] * this.data[13] - this.data[12] * this.data[9];
        double c5 = this.data[10] * this.data[15] - this.data[14] * this.data[11];
        double c4 = this.data[6] * this.data[15] - this.data[14] * this.data[7];
        double c3 = this.data[6] * this.data[11] - this.data[10] * this.data[7];
        double c2 = this.data[2] * this.data[15] - this.data[14] * this.data[3];
        double c1 = this.data[2] * this.data[11] - this.data[10] * this.data[3];
        double c0 = this.data[2] * this.data[7] - this.data[6] * this.data[3];
        Matrix4x4d mat = new Matrix4x4d();
        double rcpdet = 1.0 / (s0 * c5 - s1 * c4 + s2 * c3 + s3 * c2 - s4 * c1 + s5 * c0);
        mat.data[0] = (this.data[5] * c5 - this.data[9] * c4 + this.data[13] * c3) * rcpdet;
        mat.data[4] = (-this.data[4] * c5 + this.data[8] * c4 - this.data[12] * c3) * rcpdet;
        mat.data[8] = (this.data[7] * s5 - this.data[11] * s4 + this.data[15] * s3) * rcpdet;
        mat.data[12] = (-this.data[6] * s5 + this.data[10] * s4 - this.data[14] * s3) * rcpdet;
        mat.data[1] = (-this.data[1] * c5 + this.data[9] * c2 - this.data[13] * c1) * rcpdet;
        mat.data[5] = (this.data[0] * c5 - this.data[8] * c2 + this.data[12] * c1) * rcpdet;
        mat.data[9] = (-this.data[3] * s5 + this.data[11] * s2 - this.data[15] * s1) * rcpdet;
        mat.data[13] = (this.data[2] * s5 - this.data[10] * s2 + this.data[14] * s1) * rcpdet;
        mat.data[2] = (this.data[1] * c4 - this.data[5] * c2 + this.data[13] * c0) * rcpdet;
        mat.data[6] = (-this.data[0] * c4 + this.data[4] * c2 - this.data[12] * c0) * rcpdet;
        mat.data[10] = (this.data[3] * s4 - this.data[7] * s2 + this.data[15] * s0) * rcpdet;
        mat.data[14] = (-this.data[2] * s4 + this.data[6] * s2 - this.data[14] * s0) * rcpdet;
        mat.data[7] = (this.data[0] * c3 - this.data[4] * c1 + this.data[8] * c0) * rcpdet;
        mat.data[3] = (-this.data[1] * c3 + this.data[5] * c1 - this.data[9] * c0) * rcpdet;
        mat.data[15] = (this.data[2] * s3 - this.data[6] * s1 + this.data[10] * s0) * rcpdet;
        mat.data[11] = (-this.data[3] * s3 + this.data[7] * s1 - this.data[11] * s0) * rcpdet;
        return mat;
    }

    public Matrix4x4d transpose() {
        Matrix4x4d mat = new Matrix4x4d();
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                mat.data[y * 4 + x] = this.data[x * 4 + y];
            }
        }
        return mat;
    }

    public Matrix4x4d multiply(Matrix4x4d mat) {
        Matrix4x4d r = new Matrix4x4d();
        r.data[0] = this.data[0] * mat.data[0] + this.data[4] * mat.data[1] + this.data[8] * mat.data[2] + this.data[12] * mat.data[3];
        r.data[4] = this.data[0] * mat.data[4] + this.data[4] * mat.data[5] + this.data[8] * mat.data[6] + this.data[12] * mat.data[7];
        r.data[8] = this.data[0] * mat.data[8] + this.data[4] * mat.data[9] + this.data[8] * mat.data[10] + this.data[12] * mat.data[11];
        r.data[12] = this.data[0] * mat.data[12] + this.data[4] * mat.data[13] + this.data[8] * mat.data[14] + this.data[12] * mat.data[15];
        r.data[1] = this.data[1] * mat.data[0] + this.data[5] * mat.data[1] + this.data[9] * mat.data[2] + this.data[13] * mat.data[3];
        r.data[5] = this.data[1] * mat.data[4] + this.data[5] * mat.data[5] + this.data[9] * mat.data[6] + this.data[13] * mat.data[7];
        r.data[9] = this.data[1] * mat.data[8] + this.data[5] * mat.data[9] + this.data[9] * mat.data[10] + this.data[13] * mat.data[11];
        r.data[13] = this.data[1] * mat.data[12] + this.data[5] * mat.data[13] + this.data[9] * mat.data[14] + this.data[13] * mat.data[15];
        r.data[2] = this.data[2] * mat.data[0] + this.data[6] * mat.data[1] + this.data[10] * mat.data[2] + this.data[14] * mat.data[3];
        r.data[6] = this.data[2] * mat.data[4] + this.data[6] * mat.data[5] + this.data[10] * mat.data[6] + this.data[14] * mat.data[7];
        r.data[10] = this.data[2] * mat.data[8] + this.data[6] * mat.data[9] + this.data[10] * mat.data[10] + this.data[14] * mat.data[11];
        r.data[14] = this.data[2] * mat.data[12] + this.data[6] * mat.data[13] + this.data[10] * mat.data[14] + this.data[14] * mat.data[15];
        r.data[3] = this.data[3] * mat.data[0] + this.data[7] * mat.data[1] + this.data[11] * mat.data[2] + this.data[15] * mat.data[3];
        r.data[7] = this.data[3] * mat.data[4] + this.data[7] * mat.data[5] + this.data[11] * mat.data[6] + this.data[15] * mat.data[7];
        r.data[11] = this.data[3] * mat.data[8] + this.data[7] * mat.data[9] + this.data[11] * mat.data[10] + this.data[15] * mat.data[11];
        r.data[15] = this.data[3] * mat.data[12] + this.data[7] * mat.data[13] + this.data[11] * mat.data[14] + this.data[15] * mat.data[15];
        return r;
    }

    public Matrix4x4d toMatrix3x3() {
        Matrix4x4d ret = new Matrix4x4d();
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                ret.data[x + y * 4] = x < 3 && y < 3 ? this.data[x + y * 4] : (x == 3 && y == 3 ? 1.0 : 0.0);
            }
        }
        return ret;
    }

    public Vector3d multiply(Vector3d vec) {
        double x = vec.x;
        double y = vec.y;
        double z = vec.z;
        double rcpw = 1.0 / (x * this.data[3] + y * this.data[7] + z * this.data[11] + this.data[15]);
        vec.x = (x * this.data[0] + y * this.data[4] + z * this.data[8] + this.data[12]) * rcpw;
        vec.y = (x * this.data[1] + y * this.data[5] + z * this.data[9] + this.data[13]) * rcpw;
        vec.z = (x * this.data[2] + y * this.data[6] + z * this.data[10] + this.data[14]) * rcpw;
        return vec;
    }

    public Vector3d multiply3x3(Vector3d vec) {
        double x = vec.x;
        double y = vec.y;
        double z = vec.z;
        vec.x = x * this.data[0] + y * this.data[4] + z * this.data[8];
        vec.y = x * this.data[1] + y * this.data[5] + z * this.data[9];
        vec.z = x * this.data[2] + y * this.data[6] + z * this.data[10];
        return vec;
    }

    public Vector4d multiply(Vector4d vec) {
        double x = vec.x;
        double y = vec.y;
        double z = vec.z;
        double w = vec.w;
        vec.x = x * this.data[0] + y * this.data[4] + z * this.data[8] + w * this.data[12];
        vec.y = x * this.data[1] + y * this.data[5] + z * this.data[9] + w * this.data[13];
        vec.z = x * this.data[2] + y * this.data[6] + z * this.data[10] + w * this.data[14];
        vec.w = x * this.data[3] + y * this.data[7] + z * this.data[11] + w * this.data[15];
        return vec;
    }

    public void writeInto(double[] array, int offset) {
        System.arraycopy(this.data, 0, array, offset, 16);
    }

    public String toString() {
        return "{" + this.data[0] + ", " + this.data[4] + ", " + this.data[8] + ", " + this.data[12] + "\n" + this.data[1] + ", " + this.data[5] + ", " + this.data[9] + ", " + this.data[13] + "\n" + this.data[2] + ", " + this.data[6] + ", " + this.data[10] + ", " + this.data[14] + "\n" + this.data[3] + ", " + this.data[7] + ", " + this.data[11] + ", " + this.data[15] + "}";
    }
}

