/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.vectors;

import com.github.rjeschke.neetutils.graphics.NColor;
import com.github.rjeschke.neetutils.math.NMath;
import com.github.rjeschke.neetutils.vectors.Vector2d;
import com.github.rjeschke.neetutils.vectors.Vector3d;
import java.nio.DoubleBuffer;

public class Vector4d {
    public double w;
    public double x;
    public double y;
    public double z;

    public Vector4d() {
    }

    public Vector4d(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4d(double xyzw) {
        this.x = xyzw;
        this.y = xyzw;
        this.z = xyzw;
        this.w = xyzw;
    }

    public Vector4d(Vector2d v, double z, double w) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
        this.w = w;
    }

    public Vector4d(Vector3d v, double w) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = w;
    }

    public Vector4d(NColor color) {
        this.x = color.r;
        this.y = color.g;
        this.z = color.b;
        this.w = color.a;
    }

    public static Vector4d of(double x, double y, double z, double w) {
        return new Vector4d(x, y, z, w);
    }

    public static Vector4d of(Vector2d v, double z, double w) {
        return new Vector4d(v, z, w);
    }

    public static Vector4d of(Vector3d v, double w) {
        return new Vector4d(v, w);
    }

    public Vector4d set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4d set(double xyzw) {
        this.x = xyzw;
        this.y = xyzw;
        this.z = xyzw;
        this.w = xyzw;
        return this;
    }

    public Vector4d set(DoubleBuffer buffer, int offset) {
        this.x = buffer.get(offset);
        this.y = buffer.get(offset + 1);
        this.z = buffer.get(offset + 2);
        this.w = buffer.get(offset + 3);
        return this;
    }

    public Vector4d set(Vector2d v, double z, double w) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4d set(Vector3d v, double w) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = w;
        return this;
    }

    public Vector4d set(Vector4d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = v.w;
        return this;
    }

    public Vector4d setIdx(int index, double value) {
        if (index == 0) {
            this.x = value;
        } else if (index == 1) {
            this.y = value;
        } else if (index == 2) {
            this.z = value;
        } else {
            this.w = value;
        }
        return this;
    }

    public double get(int index) {
        if (index == 0) {
            return this.x;
        }
        if (index == 1) {
            return this.y;
        }
        if (index == 2) {
            return this.z;
        }
        return this.w;
    }

    public Vector4d scale(double f) {
        this.w *= f;
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public Vector4d add(Vector4d v) {
        this.w += v.w;
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public Vector4d add(Vector4d v, double scale) {
        this.w += v.w * scale;
        this.x += v.x * scale;
        this.y += v.y * scale;
        this.z += v.z * scale;
        return this;
    }

    public Vector4d sub(Vector4d v) {
        this.w -= v.w;
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public Vector4d sub(Vector4d v, double scale) {
        this.w -= v.w * scale;
        this.x -= v.x * scale;
        this.y -= v.y * scale;
        this.z -= v.z * scale;
        return this;
    }

    public Vector4d mul(Vector4d v) {
        this.w *= v.w;
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        return this;
    }

    public Vector4d mul(Vector4d v, double scale) {
        this.w *= v.w * scale;
        this.x *= v.x * scale;
        this.y *= v.y * scale;
        this.z *= v.z * scale;
        return this;
    }

    public Vector4d div(Vector4d v) {
        this.w /= v.w;
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        return this;
    }

    public Vector4d div(Vector4d v, double scale) {
        this.w /= v.w * scale;
        this.x /= v.x * scale;
        this.y /= v.y * scale;
        this.z /= v.z * scale;
        return this;
    }

    public Vector4d lerp(Vector4d v, double f) {
        this.x += (v.x - this.x) * f;
        this.y += (v.y - this.y) * f;
        this.z += (v.z - this.z) * f;
        this.w += (v.w - this.w) * f;
        return this;
    }

    public double dot(Vector4d v) {
        return this.w * v.w + this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public Vector4d min(Vector4d other) {
        this.x = Math.min(this.x, other.x);
        this.y = Math.min(this.y, other.y);
        this.z = Math.min(this.z, other.z);
        this.w = Math.min(this.w, other.w);
        return this;
    }

    public double min() {
        return Math.min(this.x, Math.min(this.y, Math.min(this.z, this.w)));
    }

    public Vector4d max(Vector4d other) {
        this.x = Math.max(this.x, other.x);
        this.y = Math.max(this.y, other.y);
        this.z = Math.max(this.z, other.z);
        this.w = Math.max(this.w, other.w);
        return this;
    }

    public double max() {
        return Math.max(this.x, Math.max(this.y, Math.max(this.z, this.w)));
    }

    public Vector4d clamp(Vector4d min, Vector4d max) {
        this.x = NMath.clamp(this.x, min.x, max.x);
        this.y = NMath.clamp(this.y, min.y, max.y);
        this.z = NMath.clamp(this.z, min.z, max.z);
        this.w = NMath.clamp(this.w, min.w, max.w);
        return this;
    }

    public Vector4d abs() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        this.w = Math.abs(this.w);
        return this;
    }

    public Vector4d pow(double value) {
        this.x = Math.pow(this.x, value);
        this.y = Math.pow(this.y, value);
        this.z = Math.pow(this.z, value);
        this.w = Math.pow(this.w, value);
        return this;
    }

    public Vector4d normalize() {
        double len = this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
        if (len != 0.0) {
            len = 1.0 / Math.sqrt(len);
            this.w *= len;
            this.x *= len;
            this.y *= len;
            this.z *= len;
        }
        return this;
    }

    public Vector4d negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public double length() {
        return Math.sqrt(this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector2d swizzle(int a, int b) {
        return Vector2d.of(this.get(a), this.get(b));
    }

    public Vector3d swizzle(int a, int b, int c) {
        return Vector3d.of(this.get(a), this.get(b), this.get(c));
    }

    public Vector4d swizzle(int a, int b, int c, int d) {
        return Vector4d.of(this.get(a), this.get(b), this.get(c), this.get(d));
    }

    public void into(double[] arr, int offset) {
        arr[offset] = this.x;
        arr[offset + 1] = this.y;
        arr[offset + 2] = this.z;
        arr[offset + 3] = this.w;
    }

    public void into(DoubleBuffer buffer, int offset) {
        buffer.put(offset, this.x);
        buffer.put(offset + 1, this.y);
        buffer.put(offset + 2, this.z);
        buffer.put(offset + 3, this.w);
    }

    public Vector2d asVector2() {
        return Vector2d.of(this.x, this.y);
    }

    public Vector3d asVector3() {
        return Vector3d.of(this.x, this.y, this.z);
    }

    public Vector3d asVector3DivW(Vector3d v) {
        v.x = this.x / this.w;
        v.y = this.y / this.w;
        v.z = this.z / this.w;
        return v;
    }

    public Vector3d asVector3DivW() {
        return this.asVector3DivW(new Vector3d());
    }

    public NColor asNColor() {
        return new NColor((float)this.w, (float)this.x, (float)this.y, (float)this.z);
    }

    public Vector4d clone() {
        return new Vector4d(this.x, this.y, this.z, this.w);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }
}

