/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.vectors;

import com.github.rjeschke.neetutils.graphics.NColor;
import com.github.rjeschke.neetutils.math.NMath;
import com.github.rjeschke.neetutils.vectors.Vector2f;
import com.github.rjeschke.neetutils.vectors.Vector3f;
import java.nio.FloatBuffer;

public class Vector4f {
    public float w;
    public float x;
    public float y;
    public float z;

    public Vector4f() {
    }

    public Vector4f(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4f(float xyzw) {
        this.x = xyzw;
        this.y = xyzw;
        this.z = xyzw;
        this.w = xyzw;
    }

    public Vector4f(Vector2f v, float z, float w) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
        this.w = w;
    }

    public Vector4f(Vector3f v, float w) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = w;
    }

    public Vector4f(NColor color) {
        this.x = color.r;
        this.y = color.g;
        this.z = color.b;
        this.w = color.a;
    }

    public static Vector4f of(float x, float y, float z, float w) {
        return new Vector4f(x, y, z, w);
    }

    public static Vector4f of(Vector2f v, float z, float w) {
        return new Vector4f(v, z, w);
    }

    public static Vector4f of(Vector3f v, float w) {
        return new Vector4f(v, w);
    }

    public Vector4f set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4f set(float xyzw) {
        this.x = xyzw;
        this.y = xyzw;
        this.z = xyzw;
        this.w = xyzw;
        return this;
    }

    public Vector4f set(FloatBuffer buffer, int offset) {
        this.x = buffer.get(offset);
        this.y = buffer.get(offset + 1);
        this.z = buffer.get(offset + 2);
        this.w = buffer.get(offset + 3);
        return this;
    }

    public Vector4f set(Vector2f v, float z, float w) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4f set(Vector3f v, float w) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = w;
        return this;
    }

    public Vector4f set(Vector4f v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = v.w;
        return this;
    }

    public Vector4f setIdx(int index, float value) {
        if (index == 0) {
            this.x = value;
        } else if (index == 1) {
            this.y = value;
        } else if (index == 2) {
            this.z = value;
        } else {
            this.w = value;
        }
        return this;
    }

    public float get(int index) {
        if (index == 0) {
            return this.x;
        }
        if (index == 1) {
            return this.y;
        }
        if (index == 2) {
            return this.z;
        }
        return this.w;
    }

    public Vector4f scale(float f) {
        this.w *= f;
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public Vector4f add(Vector4f v) {
        this.w += v.w;
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public Vector4f add(Vector4f v, float scale) {
        this.w += v.w * scale;
        this.x += v.x * scale;
        this.y += v.y * scale;
        this.z += v.z * scale;
        return this;
    }

    public Vector4f sub(Vector4f v) {
        this.w -= v.w;
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public Vector4f sub(Vector4f v, float scale) {
        this.w -= v.w * scale;
        this.x -= v.x * scale;
        this.y -= v.y * scale;
        this.z -= v.z * scale;
        return this;
    }

    public Vector4f mul(Vector4f v) {
        this.w *= v.w;
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        return this;
    }

    public Vector4f mul(Vector4f v, float scale) {
        this.w *= v.w * scale;
        this.x *= v.x * scale;
        this.y *= v.y * scale;
        this.z *= v.z * scale;
        return this;
    }

    public Vector4f div(Vector4f v) {
        this.w /= v.w;
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        return this;
    }

    public Vector4f div(Vector4f v, float scale) {
        this.w /= v.w * scale;
        this.x /= v.x * scale;
        this.y /= v.y * scale;
        this.z /= v.z * scale;
        return this;
    }

    public Vector4f lerp(Vector4f v, float f) {
        this.x += (v.x - this.x) * f;
        this.y += (v.y - this.y) * f;
        this.z += (v.z - this.z) * f;
        this.w += (v.w - this.w) * f;
        return this;
    }

    public float dot(Vector4f v) {
        return this.w * v.w + this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public Vector4f min(Vector4f other) {
        this.x = Math.min(this.x, other.x);
        this.y = Math.min(this.y, other.y);
        this.z = Math.min(this.z, other.z);
        this.w = Math.min(this.w, other.w);
        return this;
    }

    public float min() {
        return Math.min(this.x, Math.min(this.y, Math.min(this.z, this.w)));
    }

    public Vector4f max(Vector4f other) {
        this.x = Math.max(this.x, other.x);
        this.y = Math.max(this.y, other.y);
        this.z = Math.max(this.z, other.z);
        this.w = Math.max(this.w, other.w);
        return this;
    }

    public float max() {
        return Math.max(this.x, Math.max(this.y, Math.max(this.z, this.w)));
    }

    public Vector4f clamp(Vector4f min, Vector4f max) {
        this.x = NMath.clamp(this.x, min.x, max.x);
        this.y = NMath.clamp(this.y, min.y, max.y);
        this.z = NMath.clamp(this.z, min.z, max.z);
        this.w = NMath.clamp(this.w, min.w, max.w);
        return this;
    }

    public Vector4f abs() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        this.w = Math.abs(this.w);
        return this;
    }

    public Vector4f pow(double value) {
        this.x = (float)Math.pow(this.x, value);
        this.y = (float)Math.pow(this.y, value);
        this.z = (float)Math.pow(this.z, value);
        this.w = (float)Math.pow(this.w, value);
        return this;
    }

    public Vector4f normalize() {
        float len = this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
        if (len != 0.0f) {
            len = (float)(1.0 / Math.sqrt(len));
            this.w *= len;
            this.x *= len;
            this.y *= len;
            this.z *= len;
        }
        return this;
    }

    public Vector4f negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public float length() {
        return (float)Math.sqrt(this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector2f swizzle(int a, int b) {
        return Vector2f.of(this.get(a), this.get(b));
    }

    public Vector3f swizzle(int a, int b, int c) {
        return Vector3f.of(this.get(a), this.get(b), this.get(c));
    }

    public Vector4f swizzle(int a, int b, int c, int d) {
        return Vector4f.of(this.get(a), this.get(b), this.get(c), this.get(d));
    }

    public void into(float[] arr, int offset) {
        arr[offset] = this.x;
        arr[offset + 1] = this.y;
        arr[offset + 2] = this.z;
        arr[offset + 3] = this.w;
    }

    public void into(FloatBuffer buffer, int offset) {
        buffer.put(offset, this.x);
        buffer.put(offset + 1, this.y);
        buffer.put(offset + 2, this.z);
        buffer.put(offset + 3, this.w);
    }

    public Vector2f asVector2() {
        return Vector2f.of(this.x, this.y);
    }

    public Vector3f asVector3() {
        return Vector3f.of(this.x, this.y, this.z);
    }

    public Vector3f asVector3DivW(Vector3f v) {
        v.x = this.x / this.w;
        v.y = this.y / this.w;
        v.z = this.z / this.w;
        return v;
    }

    public Vector3f asVector3DivW() {
        return this.asVector3DivW(new Vector3f());
    }

    public NColor asNColor() {
        return new NColor(this.w, this.x, this.y, this.z);
    }

    public Vector4f clone() {
        return new Vector4f(this.x, this.y, this.z, this.w);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }
}

