/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils;

import com.github.rjeschke.neetutils.Charsets;
import com.github.rjeschke.neetutils.collections.Colls;
import java.nio.charset.Charset;
import java.util.List;

public class Strings {
    public static final String escapeString(String str) {
        if (str == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        block8: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static final String replace(String str, char oldChar, char newChar) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == oldChar) {
                sb.append(newChar);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static final List<String> split(String str, char ch) {
        List<String> ret = Colls.list();
        if (str != null) {
            int e;
            int s = 0;
            for (e = 0; e < str.length(); ++e) {
                if (str.charAt(e) != ch) continue;
                ret.add(str.substring(s, e));
                s = e + 1;
            }
            ret.add(str.substring(s, e));
        }
        return ret;
    }

    public static final List<String> trim(List<String> strings) {
        for (int i = 0; i < strings.size(); ++i) {
            String s = strings.get(i);
            if (s == null) continue;
            strings.set(i, s.trim());
        }
        return strings;
    }

    public static final boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static final String collapseWhitespace(String str) {
        StringBuilder sb = new StringBuilder();
        boolean wasWs = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c) || Character.isSpaceChar(c)) {
                if (wasWs) continue;
                sb.append(' ');
                wasWs = true;
                continue;
            }
            wasWs = false;
            sb.append(c);
        }
        return sb.toString();
    }

    public static final String join(Iterable<String> iterable, String glue) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (String s : iterable) {
            if (index > 0) {
                sb.append(glue);
            }
            sb.append(s);
            ++index;
        }
        return sb.toString();
    }

    public static final String join(Iterable<String> iterable) {
        StringBuilder sb = new StringBuilder();
        for (String s : iterable) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static final List<String> splitLength(String str, int len) {
        int n;
        List<String> ret = Colls.list();
        int pos = 0;
        for (int todo = str.length(); todo > 0; todo -= n) {
            n = Math.min(todo, len);
            ret.add(str.substring(pos, pos + n));
            pos += n;
        }
        return ret;
    }

    public static final int firstDiffIndex(String a, String b) {
        int i;
        int todo = Math.min(a.length(), b.length());
        for (i = 0; i < todo && a.charAt(i) == b.charAt(i); ++i) {
        }
        return i;
    }

    public static final String from(byte[] bytes, int offs, int length, Charset charset) {
        return new String(bytes, offs, length, charset);
    }

    public static final String from(byte[] bytes, Charset charset) {
        return new String(bytes, charset);
    }

    public static final String from(byte[] bytes, int offs, int length) {
        return new String(bytes, offs, length, Charsets.UTF8);
    }

    public static final String from(byte[] bytes) {
        return new String(bytes, Charsets.UTF8);
    }
}

