/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils;

public class Timer
implements Runnable {
    private final long delay;
    private final Callback callback;
    private volatile boolean running = true;

    private Timer(double freq, Callback callback) {
        this.delay = (long)(1.0E9 / freq);
        this.callback = callback;
    }

    public static Timer start(double freq, Callback callback) {
        Timer t = new Timer(freq, callback);
        Thread th = new Thread(t);
        th.setDaemon(true);
        th.start();
        return t;
    }

    public void stop() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object sleeper = new Object();
        long toWait = 0L;
        long t0 = System.nanoTime();
        try {
            while (this.running) {
                this.callback.timerCallback();
                long t1 = System.nanoTime() - t0;
                Object object = sleeper;
                synchronized (object) {
                    long millis = (toWait += this.delay - t1) / 1000000L;
                    if (millis >= 0L) {
                        sleeper.wait(millis);
                        toWait -= millis * 1000000L;
                    }
                }
                t0 += this.delay;
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public static interface Callback {
        public void timerCallback();
    }
}

