/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.ai;

import com.github.rjeschke.neetutils.SysUtils;
import com.github.rjeschke.neetutils.ai.Layer;
import com.github.rjeschke.neetutils.ai.TransferFunction;
import com.github.rjeschke.neetutils.io.NInputStream;
import com.github.rjeschke.neetutils.io.NOutputStream;
import com.github.rjeschke.neetutils.rng.RNG;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

@Deprecated
public class Net {
    final Layer[] layers;
    public final int numInputs;
    public final int numOutputs;

    Net(int numLayers, int numInputs, int numOutputs) {
        this.layers = new Layer[numLayers];
        this.numInputs = numInputs;
        this.numOutputs = numOutputs;
    }

    public Net clone() {
        Net net = new Net(this.layers.length, this.numInputs, this.numOutputs);
        for (int i = 0; i < this.layers.length; ++i) {
            net.layers[i] = this.layers[i].clone();
        }
        return net;
    }

    public Net randomize() {
        for (Layer l : this.layers) {
            Arrays.fill(l.matrix, 0.0);
            for (int i = 0; i < l.matrix.length; ++i) {
                while (l.matrix[i] == 0.0) {
                    l.matrix[i] = SysUtils.rndDoubleBipolar();
                }
            }
        }
        return this;
    }

    public Net randomize(RNG rng) {
        for (Layer l : this.layers) {
            Arrays.fill(l.matrix, 0.0);
            for (int i = 0; i < l.matrix.length; ++i) {
                while (l.matrix[i] == 0.0) {
                    l.matrix[i] = rng.nextDoubleBipolar();
                }
            }
        }
        return this;
    }

    public Net clear() {
        for (Layer l : this.layers) {
            Arrays.fill(l.matrix, 0.0);
        }
        return this;
    }

    public Net zeroNaNsAndInfs() {
        for (Layer l : this.layers) {
            l.zeroNaNsAndInfs();
        }
        return this;
    }

    public double[] run(double[] inputs, double[] outputs) {
        Layer.State[] states = this.createStates(outputs);
        for (int i = 0; i < this.layers.length; ++i) {
            if (i == 0) {
                this.layers[i].eval(inputs, states[i].values);
                continue;
            }
            this.layers[i].eval(states[i - 1].values, states[i].values);
        }
        return outputs;
    }

    double[] run(Layer.State[] states) {
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i].eval(states[i].values, states[i + 1].values);
        }
        return states[this.layers.length].values;
    }

    Layer.State[] createStates(double[] outputs) {
        Layer.State[] s = new Layer.State[this.layers.length];
        for (int i = 0; i < this.layers.length; ++i) {
            s[i] = i == this.layers.length - 1 ? this.layers[i].createState(outputs) : this.layers[i].createState();
        }
        return s;
    }

    Layer.State[] createExtraStates(double[] inputs) {
        Layer.State[] s = new Layer.State[this.layers.length + 1];
        for (int i = 0; i < this.layers.length + 1; ++i) {
            s[i] = i == 0 ? new Layer.State(inputs) : this.layers[i - 1].createState();
        }
        return s;
    }

    public void toStream(NOutputStream out) throws IOException {
        out.write32(this.layers.length);
        out.write32(this.numInputs);
        out.write32(this.numOutputs);
        for (Layer l : this.layers) {
            l.toStream(out);
        }
    }

    public static Net fromStream(NInputStream in) throws IOException {
        int l = in.readI32();
        int a = in.readI32();
        int b = in.readI32();
        Net net = new Net(l, a, b);
        for (int i = 0; i < l; ++i) {
            net.layers[i] = Layer.fromStream(in);
        }
        return net;
    }

    public static Builder builder(int numInputs) {
        return new Builder(numInputs);
    }

    public static class Builder {
        private final int numInputs;
        ArrayList<Integer> outputs = new ArrayList();
        ArrayList<TransferFunction> tfs = new ArrayList();

        Builder(int numInputs) {
            this.numInputs = numInputs;
        }

        public Builder addLayer(int outputs, TransferFunction tf) {
            if (outputs < 1) {
                throw new IllegalArgumentException("Number of outputs must be greater than zero");
            }
            this.outputs.add(outputs);
            this.tfs.add(tf);
            return this;
        }

        public Net build() {
            if (this.outputs.size() == 0) {
                throw new IllegalStateException("At least one layer is needed");
            }
            Net net = new Net(this.outputs.size(), this.numInputs, this.outputs.get(this.outputs.size() - 1));
            for (int i = 0; i < net.layers.length; ++i) {
                net.layers[i] = new Layer(this.tfs.get(i), i == 0 ? this.numInputs : this.outputs.get(i - 1), this.outputs.get(i));
            }
            return net;
        }
    }
}

