/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.audio.Clipper;
import com.github.rjeschke.neetutils.audio.DefaultClipper;

public class HPF6dBVar {
    private final double fs;
    private double f;
    private double f2;
    private double b = 0.0;
    private double fb = 1.0;
    private Clipper clipper = new DefaultClipper();

    public HPF6dBVar(double fs) {
        this.fs = fs;
        this.setCutoff(fs * 0.1);
    }

    public void setCutoff(double freq) {
        this.f = Math.tan(Math.PI * freq / this.fs);
        this.f2 = 1.0 / (1.0 + this.f * this.fb);
    }

    public void reset() {
        this.b = 0.0;
    }

    public HPF6dBVar setFeedback(double fb) {
        this.fb = fb;
        this.f2 = 1.0 / (1.0 + this.f * this.fb);
        return this;
    }

    public double coef(double previous) {
        return previous * this.f2;
    }

    public double output(double input) {
        return (input - this.b) * this.f2;
    }

    public double tick(double input) {
        double o = (this.b + this.f * input) * this.f2;
        this.b = this.clipper.clip(o + this.f * (input - this.fb * o));
        return input - o;
    }

    public HPF6dBVar setClipper(Clipper clipper) {
        this.clipper = clipper;
        return this;
    }
}

