/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.audio.Clipper;
import com.github.rjeschke.neetutils.audio.DefaultClipper;

public class LPF24dBLadder {
    private double b0;
    private double b1;
    private double b2;
    private double b3;
    private double q;
    private double f;
    private double f2;
    private double f3;
    private double fr;
    private final double fs;
    private Clipper clipper = new DefaultClipper();

    public LPF24dBLadder(double fs) {
        this.fs = fs;
        this.setCutoff(fs * 0.1);
    }

    public void setCutoff(double freq) {
        this.f = Math.tan(Math.PI * freq / this.fs);
        this.recalc();
    }

    private void recalc() {
        this.f2 = 1.0 / (1.0 + this.f);
        this.f3 = this.f * this.f2;
        double t = this.f3 * this.f3;
        this.fr = this.f2 / (1.0 + this.q * t * t);
    }

    public void setQ(double q) {
        this.q = q;
        this.recalc();
    }

    public void reset() {
        this.b3 = 0.0;
        this.b2 = 0.0;
        this.b1 = 0.0;
        this.b0 = 0.0;
    }

    public LPF24dBLadder setClipper(Clipper clipper) {
        this.clipper = clipper;
        return this;
    }

    public double process(double input) {
        double out = (this.b3 + this.f3 * (this.b2 + this.f3 * (this.b1 + this.f3 * (this.b0 + this.f * input)))) * this.fr;
        double in = input - this.q * out;
        double o0 = (this.b0 + this.f * in) * this.f2;
        double o1 = (this.b1 + this.f * o0) * this.f2;
        double o2 = (this.b2 + this.f * o1) * this.f2;
        double o3 = (this.b3 + this.f * o2) * this.f2;
        this.b0 = this.clipper.clip(o0 + this.f * (in - o0));
        this.b1 = o1 + this.f * (o0 - o1);
        this.b2 = o2 + this.f * (o1 - o2);
        this.b3 = o3 + this.f * (o2 - o3);
        return out;
    }
}

