/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.audio.DigitalOSC;
import com.github.rjeschke.neetutils.audio.WaveMipMap;
import com.github.rjeschke.neetutils.math.NMath;

public class MipMapOSC {
    private final double fs2;
    private int maxPitch;
    private WaveMipMap mipMap;
    private final double pitchFactor;
    private int phase;
    private int step;
    private int lastPitch = 3600;
    private WaveMipMap.MipWave wave0;
    private WaveMipMap.MipWave wave1;
    private double waveCrossfade;
    private boolean isCrossfade;
    private final int noteMaximum;

    public MipMapOSC(WaveMipMap mipMap, double fs) {
        this(mipMap, fs, 128);
    }

    public MipMapOSC(WaveMipMap mipMap, double fs, int noteMaximum) {
        this.pitchFactor = 2.68435456E8 / fs;
        this.fs2 = fs * 0.5;
        this.noteMaximum = NMath.clamp(noteMaximum, 64, 128);
        this.setMipMap(mipMap);
    }

    public void setMipMap(WaveMipMap mipMap) {
        this.maxPitch = Math.min(this.noteMaximum, DigitalOSC.pitchFromFreq(this.fs2 / (double)mipMap.minHarmonics) / 100) * 100 - 1;
        System.out.println(this.maxPitch);
        this.mipMap = mipMap;
        this.setPitch(this.lastPitch);
    }

    public void setPitch(int cents) {
        this.lastPitch = NMath.clamp(cents, 0, this.maxPitch);
        double freq = 440.0 * NMath.exp2((double)(this.lastPitch - 6900) / 1200.0);
        int harmonics = (int)Math.ceil(this.fs2 / freq);
        int mi = this.mipMap.getMipMapIndex(harmonics);
        this.wave0 = this.mipMap.getMipMap(mi);
        if (mi + 1 < this.mipMap.size() && harmonics < this.mipMap.first.harmonics) {
            this.isCrossfade = true;
            this.wave1 = this.mipMap.getMipMap(mi + 1);
            this.waveCrossfade = 1.0 - Math.pow((double)harmonics / (double)this.wave0.harmonics - 1.0, 0.125);
        } else {
            this.isCrossfade = false;
        }
        this.step = (int)(this.pitchFactor * freq);
    }

    public void setPhase(int phase) {
        this.phase = phase & 0xFFFFFFF;
    }

    public double tick() {
        double out;
        if (this.isCrossfade) {
            double s0 = this.wave0.get(this.phase);
            out = this.waveCrossfade * (this.wave1.get(this.phase) - s0) + s0;
        } else {
            out = this.wave0.get(this.phase);
        }
        this.phase = this.phase + this.step & 0xFFFFFFF;
        return out;
    }
}

