/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.audio.Clipper;
import com.github.rjeschke.neetutils.audio.SVF12dB;

public class PeakingFilter12dB {
    private final SVF12dB svf;
    private double fc;
    private double bg;
    private double gain;
    private double bandwidth;

    public PeakingFilter12dB(double fs) {
        this.svf = new SVF12dB(fs);
        this.gain = 0.0;
        this.bandwidth = fs / 10.0;
        this.setCutoff(fs * 0.1);
    }

    public void setCutoff(double cutoff) {
        this.fc = cutoff;
        this.svf.setCutoff(this.fc);
        this.recalc();
    }

    public void setGain(double db) {
        this.gain = db;
        this.recalc();
    }

    public void setBandwidth(double bw) {
        this.bandwidth = bw;
        this.recalc();
    }

    public void reset() {
        this.svf.reset();
    }

    private void recalc() {
        double b = this.bandwidth / this.fc;
        double g = Math.pow(10.0, this.gain / 20.0);
        this.bg = b * g;
        this.svf.setRawQ(b);
    }

    public PeakingFilter12dB setClipper(Clipper clipper) {
        this.svf.setClipper(clipper);
        return this;
    }

    public double process(double input) {
        this.svf.process(input);
        return this.svf.low() + this.bg * this.svf.band() + this.svf.high();
    }
}

