/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.audio.FIRUtils;
import com.github.rjeschke.neetutils.audio.Resampler;
import com.github.rjeschke.neetutils.audio.ResamplerDown;
import com.github.rjeschke.neetutils.audio.ResamplerNone;
import com.github.rjeschke.neetutils.audio.ResamplerUp;
import com.github.rjeschke.neetutils.math.NMath;

public final class ResamplerFactory {
    private ResamplerFactory() {
    }

    public static final Resampler create(double srcFs, double targetFs, double[] firFilter) {
        if (NMath.doubleEquals(srcFs, targetFs, 1.0E-5)) {
            return new ResamplerNone();
        }
        if (srcFs < targetFs) {
            return new ResamplerUp(srcFs, targetFs, firFilter);
        }
        return new ResamplerDown(srcFs, targetFs, firFilter);
    }

    public static final Resampler create(double srcFs, double targetFs, int firOrder) {
        if (NMath.doubleEquals(srcFs, targetFs, 1.0E-5)) {
            return new ResamplerNone();
        }
        if (srcFs < targetFs) {
            return new ResamplerUp(srcFs, targetFs, FIRUtils.windowBlackman(FIRUtils.createLowpass(firOrder, srcFs * 0.45, targetFs)));
        }
        return new ResamplerDown(srcFs, targetFs, FIRUtils.windowBlackman(FIRUtils.createLowpass(firOrder, targetFs * 0.45, srcFs)));
    }

    public static final Resampler create(double srcFs, double targetFs, double transitionWidth, double attenuation) {
        if (NMath.doubleEquals(srcFs, targetFs, 1.0E-5)) {
            return new ResamplerNone();
        }
        double safeTw = NMath.clamp(transitionWidth, 1.0, 50.0) / 100.0;
        if (srcFs < targetFs) {
            double tw = srcFs * 0.5 * safeTw;
            double[] win = FIRUtils.windowKaiser(tw, attenuation, targetFs);
            return new ResamplerUp(srcFs, targetFs, FIRUtils.multiply(FIRUtils.createLowpass(win.length - 1, srcFs * 0.5 - tw, targetFs), win));
        }
        double tw = targetFs * 0.5 * safeTw;
        double[] win = FIRUtils.windowKaiser(tw, attenuation, srcFs);
        return new ResamplerDown(srcFs, targetFs, FIRUtils.multiply(FIRUtils.createLowpass(win.length - 1, targetFs * 0.5 - tw, srcFs), win));
    }
}

