/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.audio.Clipper;
import com.github.rjeschke.neetutils.audio.DefaultClipper;

public class SVF12dB {
    private final double fs;
    private double f;
    private double bl;
    private double bb;
    private double r = Math.sqrt(2.0);
    private double t;
    private double tf;
    private double u;
    private double low;
    private double high;
    private double band;
    private Clipper clipper = new DefaultClipper();

    public SVF12dB(double fs) {
        this.fs = fs;
        this.setCutoff(fs * 0.1);
    }

    public double low() {
        return this.low;
    }

    public double band() {
        return this.band;
    }

    public double high() {
        return this.high;
    }

    public double getF() {
        return this.f;
    }

    public void setCutoff(double cutoff) {
        this.f = Math.tan(Math.PI * cutoff / this.fs);
        this.recalc();
    }

    private void recalc() {
        this.t = 1.0 / (1.0 + this.r * this.f);
        this.tf = this.t * this.f;
        this.u = 1.0 / (1.0 + this.t * this.f * this.f);
    }

    public void setRawQ(double r) {
        this.r = r;
        this.recalc();
    }

    public SVF12dB setClipper(Clipper clipper) {
        this.clipper = clipper;
        return this;
    }

    public SVF12dB process(double input) {
        this.low = (this.bl + this.tf * (this.bb + this.f * input)) * this.u;
        this.band = (this.bb + this.f * (input - this.low)) * this.t;
        this.high = input - this.low - this.r * this.band;
        this.bb = this.clipper.clip(this.band + this.f * this.high);
        this.bl = this.clipper.clip(this.low + this.f * this.band);
        return this;
    }

    public void reset() {
        this.bb = 0.0;
        this.bl = 0.0;
    }
}

