/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.io.NInputStreamLE;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class WavReader {
    private final int sampleRate;
    private final int channels;
    private final float[] data;
    private final int[] originalData;

    private WavReader(int sampleRate, int channels, float[] data, int[] originalData) {
        this.sampleRate = sampleRate;
        this.channels = channels;
        this.data = data;
        this.originalData = originalData;
    }

    public int getSamplerate() {
        return this.sampleRate;
    }

    public int getChannelCount() {
        return this.channels;
    }

    public float[] getData() {
        return this.data;
    }

    public int[] getOriginalData() {
        return this.originalData;
    }

    public static WavReader load(String filename) throws IOException {
        return WavReader.load(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WavReader load(File file) throws IOException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            WavReader wavReader = WavReader.load(new BufferedInputStream(fis));
            return wavReader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WavReader load(InputStream input) throws IOException {
        try (NInputStreamLE in = null;){
            in = new NInputStreamLE(input);
            if (!in.readString(4, 0).equals("RIFF")) {
                throw new IOException("Not a WAV file.");
            }
            in.readI32();
            if (!in.readString(4, 0).equals("WAVE")) {
                throw new IOException("Not a WAV file.");
            }
            if (!in.readString(4, 0).equals("fmt ")) {
                throw new IOException("Not a WAV file.");
            }
            int fmtSz = in.readI32();
            int fmt = in.readU16();
            if (fmt != 1 || fmtSz != 16) {
                throw new IOException("Unsupported WAV format");
            }
            int channels = in.readU16();
            int samplerate = in.readI32();
            in.readI32();
            in.readU16();
            int bits = in.readU16();
            String tmp = in.readString(4, 0);
            while (!tmp.equals("data")) {
                int toskip = in.readI32();
                if (in.skip(toskip) != (long)toskip) {
                    throw new IOException("Unsupported WAV format");
                }
                tmp = in.readString(4, 0);
            }
            int length = in.readI32() / (bits * channels >> 3);
            float[] ret = new float[length * channels];
            int[] iret = new int[length * channels];
            for (int i = 0; i < ret.length; ++i) {
                int v = 0;
                if (bits == 8) {
                    iret[i] = in.readU8() - 128;
                    v = iret[i] << 16;
                } else if (bits == 16) {
                    iret[i] = in.readI16();
                    v = iret[i] << 8;
                } else if (bits == 24) {
                    iret[i] = v = in.readI24();
                } else {
                    throw new IOException("Unsupported bit depth: " + bits);
                }
                ret[i] = (float)v / 8388608.0f;
            }
            WavReader wavReader = new WavReader(samplerate, channels, ret, iret);
            return wavReader;
        }
    }
}

