/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.collections;

import java.util.Arrays;
import java.util.NoSuchElementException;

public class BinaryHeap<T extends Comparable<T>> {
    public static final double DEFAULT_GROWTH_FACTOR = 0.5;
    public static final int DEFAULT_INITIAL_SIZE = 16;
    private Object[] data;
    private int size;
    private final int compMod;
    private final double growthFactor;

    public BinaryHeap(Type type) {
        this(type, 16, 0.5);
    }

    public BinaryHeap(Type type, int initialSize) {
        this(type, initialSize, 0.5);
    }

    public BinaryHeap(Type type, int initialSize, double growthFactor) {
        this.data = new Object[Math.max(initialSize, 1)];
        this.growthFactor = growthFactor;
        this.compMod = type == Type.MAX ? 1 : -1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        Arrays.fill(this.data, null);
        this.size = 0;
    }

    public void shrinkToFit() {
        if (this.size != this.data.length) {
            this.data = Arrays.copyOf(this.data, this.size);
        }
    }

    void ensureCapacity() {
        if (this.size >= this.data.length) {
            int newLen = this.data.length + Math.max(1, (int)((double)this.data.length * this.growthFactor));
            this.data = Arrays.copyOf(this.data, newLen);
        }
    }

    public T get() {
        return (T)(this.size != 0 ? (Comparable)this.data[0] : null);
    }

    public T remove() {
        int child;
        if (this.size == 0) {
            throw new NoSuchElementException("Heap is empty");
        }
        Comparable removed = (Comparable)this.data[0];
        this.data[0] = this.data[--this.size];
        this.data[this.size] = null;
        int pos = 0;
        while ((child = 2 * pos + 1) < this.size) {
            Comparable b;
            Comparable a;
            if (child + 1 < this.size && ((Comparable)this.data[child]).compareTo((Comparable)this.data[child + 1]) * this.compMod < 0) {
                ++child;
            }
            if ((a = (Comparable)this.data[pos]).compareTo(b = (Comparable)this.data[child]) * this.compMod >= 0) break;
            this.data[pos] = b;
            this.data[child] = a;
            pos = child;
        }
        return (T)removed;
    }

    public void put(T e) {
        Comparable b;
        Comparable a;
        int parent;
        this.ensureCapacity();
        this.data[this.size] = e;
        int pos = this.size++;
        while ((parent = pos - 1 >> 1) >= 0 && (a = (Comparable)this.data[pos]).compareTo(b = (Comparable)this.data[parent]) * this.compMod > 0) {
            this.data[pos] = b;
            this.data[parent] = a;
            pos = parent;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.data[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static enum Type {
        MIN,
        MAX;

    }
}

