/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.fn;

import com.github.rjeschke.neetutils.fn.FnPredicate;

public final class CharacterFns {
    private CharacterFns() {
    }

    public static final FnPredicate<Character> notWhitespace() {
        return new FnPredicate<Character>(){

            @Override
            public boolean applyPredicate(Character a) {
                return !Character.isWhitespace(a.charValue()) && !Character.isSpaceChar(a.charValue());
            }
        };
    }

    public static final FnPredicate<Character> isWhitespace() {
        return new FnPredicate<Character>(){

            @Override
            public boolean applyPredicate(Character a) {
                return Character.isWhitespace(a.charValue()) || Character.isSpaceChar(a.charValue());
            }
        };
    }

    public static final FnPredicate<Character> isLetter() {
        return new FnPredicate<Character>(){

            @Override
            public boolean applyPredicate(Character a) {
                return Character.isLetter(a.charValue());
            }
        };
    }

    public static final FnPredicate<Character> notLetter() {
        return new FnPredicate<Character>(){

            @Override
            public boolean applyPredicate(Character a) {
                return !Character.isLetter(a.charValue());
            }
        };
    }

    public static final FnPredicate<Character> isDigit() {
        return new FnPredicate<Character>(){

            @Override
            public boolean applyPredicate(Character a) {
                return Character.isDigit(a.charValue());
            }
        };
    }

    public static final FnPredicate<Character> notDigit() {
        return new FnPredicate<Character>(){

            @Override
            public boolean applyPredicate(Character a) {
                return !Character.isDigit(a.charValue());
            }
        };
    }

    public static final FnPredicate<Character> isLetterOrDigit() {
        return new FnPredicate<Character>(){

            @Override
            public boolean applyPredicate(Character a) {
                return Character.isLetterOrDigit(a.charValue());
            }
        };
    }

    public static final FnPredicate<Character> notLetterOrDigit() {
        return new FnPredicate<Character>(){

            @Override
            public boolean applyPredicate(Character a) {
                return !Character.isLetterOrDigit(a.charValue());
            }
        };
    }

    public static final FnPredicate<Character> isUpperCase() {
        return new FnPredicate<Character>(){

            @Override
            public boolean applyPredicate(Character a) {
                return Character.isUpperCase(a.charValue());
            }
        };
    }

    public static final FnPredicate<Character> isLowerCase() {
        return new FnPredicate<Character>(){

            @Override
            public boolean applyPredicate(Character a) {
                return Character.isLowerCase(a.charValue());
            }
        };
    }
}

