/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.graphics;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;

public class ImageUtils {
    public static BufferedImage toGrayscale(BufferedImage image) {
        BufferedImage work;
        if (image.getType() == 10) {
            return image;
        }
        int w = image.getWidth();
        int h = image.getHeight();
        if (image.getType() == 1) {
            work = image;
        } else {
            work = new BufferedImage(w, h, 1);
            Graphics2D g = work.createGraphics();
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
        }
        BufferedImage out = new BufferedImage(w, h, 10);
        int[] ip = ((DataBufferInt)work.getRaster().getDataBuffer()).getData();
        byte[] op = ((DataBufferByte)out.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int p = x + y * w;
                int c = ip[p];
                int r = c >> 16 & 0xFF;
                int g = c >> 8 & 0xFF;
                int b = c & 0xFF;
                op[p] = (byte)(r * 77 + g * 150 + b * 29 >> 8);
            }
        }
        return out;
    }
}

