/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.io;

import com.github.rjeschke.neetutils.io.BEIO;
import com.github.rjeschke.neetutils.io.NInputStreamBE;
import com.github.rjeschke.neetutils.io.NInputStreamLE;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public abstract class NInputStream
extends FilterInputStream {
    protected NInputStream(InputStream in) {
        super(in);
    }

    public static NInputStream fromStream(InputStream in, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return new NInputStreamBE(in);
        }
        return new NInputStreamLE(in);
    }

    public abstract int readI8() throws IOException;

    public abstract int readU8() throws IOException;

    public abstract int readI16() throws IOException;

    public abstract int readU16() throws IOException;

    public abstract int readI24() throws IOException;

    public abstract int readU24() throws IOException;

    public abstract int readI32() throws IOException;

    public abstract long readU32() throws IOException;

    public abstract long readI64() throws IOException;

    public abstract float readFloat() throws IOException;

    public abstract double readDouble() throws IOException;

    public abstract String readString8() throws IOException;

    public abstract String readString16() throws IOException;

    public abstract String readString32() throws IOException;

    public abstract String readString(int var1, int var2, String var3) throws IOException;

    public abstract String readString(int var1, int var2) throws IOException;

    public abstract String readString(int var1) throws IOException;

    public abstract ByteOrder getByteOrder();

    @Override
    public int read(byte[] b) throws IOException {
        return BEIO.readBytes(this.in, b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return BEIO.readBytes(this.in, b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return BEIO.skipBytes(this.in, n);
    }
}

