/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.iterables;

import com.github.rjeschke.neetutils.iterables.AbstractXIterable;
import java.util.Arrays;
import java.util.Iterator;

public class ArrayIterator<A>
extends AbstractXIterable<A> {
    private final A[] values;

    @SafeVarargs
    public ArrayIterator(boolean defensiveCopy, A ... values) {
        this.values = defensiveCopy ? Arrays.copyOf(values, values.length) : values;
    }

    @SafeVarargs
    public ArrayIterator(A ... values) {
        this(true, values);
    }

    @SafeVarargs
    public static final <A> ArrayIterator<A> of(A ... values) {
        return new ArrayIterator<A>(values);
    }

    @SafeVarargs
    public static final <A> ArrayIterator<A> unsafeOf(A ... values) {
        return new ArrayIterator<A>(false, values);
    }

    @Override
    public Iterator<A> iterator() {
        return new XIterator<A>(this.values);
    }

    private static final class XIterator<A>
    implements Iterator<A> {
        private final A[] values;
        private int position = 0;

        @SafeVarargs
        public XIterator(A ... values) {
            this.values = values;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.values.length;
        }

        @Override
        public A next() {
            return this.values[this.position++];
        }

        @Override
        public void remove() {
            throw new IllegalStateException("ArrayIterator is read-only.");
        }
    }
}

