/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.iterables;

import com.github.rjeschke.neetutils.collections.Tuple;
import com.github.rjeschke.neetutils.fn.FnCombine;
import com.github.rjeschke.neetutils.fn.FnFoldStep;
import com.github.rjeschke.neetutils.fn.FnMapping;
import com.github.rjeschke.neetutils.fn.FnPredicate;
import com.github.rjeschke.neetutils.iterables.ArrayIterator;
import com.github.rjeschke.neetutils.iterables.Collector;
import com.github.rjeschke.neetutils.iterables.XIterable;
import com.github.rjeschke.neetutils.iterables.XIterableCollect;
import com.github.rjeschke.neetutils.iterables.XIterableConcat;
import com.github.rjeschke.neetutils.iterables.XIterableConcat2;
import com.github.rjeschke.neetutils.iterables.XIterableDrop;
import com.github.rjeschke.neetutils.iterables.XIterableFilter;
import com.github.rjeschke.neetutils.iterables.XIterableGeneric;
import com.github.rjeschke.neetutils.iterables.XIterableInterleave;
import com.github.rjeschke.neetutils.iterables.XIterableMap;
import com.github.rjeschke.neetutils.iterables.XIterableReductions;
import com.github.rjeschke.neetutils.iterables.XIterableReductions2;
import com.github.rjeschke.neetutils.iterables.XIterableTake;
import com.github.rjeschke.neetutils.iterables.XIterableZip;
import com.github.rjeschke.neetutils.iterables.XIterableZipWith;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Iterables {
    private Iterables() {
    }

    public static final <A> XIterable<A> asXIterable(Iterable<A> iterable) {
        if (iterable instanceof XIterable) {
            return (XIterable)iterable;
        }
        return new XIterableGeneric<A>(iterable);
    }

    public static final <A> String asString(Iterable<A> iterable) {
        StringBuilder sb = new StringBuilder();
        for (A a : iterable) {
            sb.append(a);
        }
        return sb.toString();
    }

    public static final <A> List<A> asList(Iterable<? extends A> iterable) {
        return Iterables.asList(iterable, new ArrayList());
    }

    public static final <A> List<A> asList(Iterable<? extends A> iterable, List<A> list) {
        for (A a : iterable) {
            list.add(a);
        }
        return list;
    }

    public static final <A> Set<A> asSet(Iterable<? extends A> iterable) {
        return Iterables.asSet(iterable, new HashSet());
    }

    public static final <A> Set<A> asSet(Iterable<? extends A> iterable, Set<A> set) {
        for (A a : iterable) {
            set.add(a);
        }
        return set;
    }

    public static final <A, B> Map<A, B> asMap(Iterable<? extends Tuple<? extends A, ? extends B>> iterable) {
        return Iterables.asMap(iterable, new HashMap());
    }

    public static final <A, B> Map<A, B> asMap(Iterable<? extends Tuple<? extends A, ? extends B>> iterable, Map<A, B> map) {
        for (Tuple<A, B> tuple : iterable) {
            map.put(tuple.a, tuple.b);
        }
        return map;
    }

    public static final <A, B> Map<? super A, ? super B> asMap(Iterable<? extends A> iterableA, Iterable<? extends B> iterableB) {
        return Iterables.asMap(iterableA, iterableB, new HashMap());
    }

    public static final <A, B> Map<? super A, ? super B> asMap(Iterable<? extends A> iterableA, Iterable<? extends B> iterableB, Map<? super A, ? super B> map) {
        Iterator<A> ai = iterableA.iterator();
        Iterator<B> bi = iterableB.iterator();
        while (ai.hasNext() && bi.hasNext()) {
            map.put(ai.next(), bi.next());
        }
        return map;
    }

    public static final <A, B> XIterable<B> collect(Iterable<A> iterable, Collector<? super A, B> collector) {
        return new XIterableCollect<A, B>(iterable, collector);
    }

    public static final <A> XIterable<A> take(Iterable<A> iterable, int amount) {
        return new XIterableTake<A>(iterable, amount);
    }

    public static final <A> void consume(Iterable<A> iterable) {
        Iterator<A> i = iterable.iterator();
        while (i.hasNext()) {
            i.next();
        }
    }

    public static final <A> XIterable<A> drop(Iterable<A> iterable, int amount) {
        return new XIterableDrop<A>(iterable, amount);
    }

    public static final <A> XIterable<A> concat(Iterable<? extends A> iterableA, Iterable<? extends A> iterableB) {
        return new XIterableConcat<A>(iterableA, iterableB);
    }

    @SafeVarargs
    public static final <A> XIterable<A> concat(Iterable<? extends A> ... iterables) {
        return new XIterableConcat2<A>(ArrayIterator.unsafeOf(iterables));
    }

    @SafeVarargs
    public static final <A> XIterable<A> concat(Iterable<? extends A> iterable, Iterable<? extends A> ... iterables) {
        return new XIterableConcat<A>(iterable, new XIterableConcat2<A>(ArrayIterator.unsafeOf(iterables)));
    }

    public static final <A> XIterable<A> concat(Iterable<? extends Iterable<? extends A>> iterable) {
        return new XIterableConcat2(iterable);
    }

    public static final <A> XIterable<A> filter(Iterable<? extends A> iterable, FnPredicate<? super A> predicate) {
        return new XIterableFilter<A>(iterable, predicate);
    }

    public static final <A, B> XIterable<B> map(Iterable<? extends A> iterable, FnMapping<A, B> mapping) {
        return new XIterableMap<A, B>(iterable, mapping);
    }

    public static final <A, B> B reduce(Iterable<A> iterable, FnFoldStep<? super A, B> foldStep, B initialValue) {
        B b = initialValue;
        for (A a : iterable) {
            b = foldStep.applyFoldStep(a, b);
        }
        return b;
    }

    public static final <A, B> XIterable<B> reductions(Iterable<A> iterable, FnFoldStep<? super A, B> foldStep, B initialValue) {
        return new XIterableReductions<A, B>(iterable, foldStep, initialValue);
    }

    public static final <A> A reduce(Iterable<A> iterable, FnFoldStep<? super A, A> foldStep) {
        Object a = null;
        Iterator<A> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            a = iterator.next();
            while (iterator.hasNext()) {
                a = foldStep.applyFoldStep(iterator.next(), a);
            }
        }
        return a;
    }

    public static final <A> XIterable<A> reductions(Iterable<? extends A> iterable, FnFoldStep<? super A, A> foldStep) {
        return new XIterableReductions2<A>(iterable, foldStep);
    }

    public static final <A> XIterable<A> interleave(Iterable<? extends A> iterableA, Iterable<? extends A> iterableB) {
        return new XIterableInterleave<A>(iterableA, iterableB);
    }

    public static final <A, B> XIterable<Tuple<A, B>> zip(Iterable<A> iterableA, Iterable<B> iterableB) {
        return new XIterableZip<A, B>(iterableA, iterableB);
    }

    public static final <A, B, C> XIterable<C> zipWith(Iterable<A> iterableA, Iterable<B> iterableB, FnCombine<? super A, ? super B, C> combine) {
        return new XIterableZipWith<A, B, C>(iterableA, iterableB, combine);
    }

    public static final <A> String iterableToString(Iterable<A> iterable) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (A a : iterable) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(a.toString());
        }
        sb.append(']');
        return sb.toString();
    }

    public static final <A> Iterable<A> constant(final A value) {
        return new Iterable<A>(){

            @Override
            public Iterator<A> iterator() {
                return new Iterator<A>(){

                    @Override
                    public boolean hasNext() {
                        return true;
                    }

                    @Override
                    public A next() {
                        return value;
                    }

                    @Override
                    public void remove() {
                        throw new IllegalStateException("Constant iterators are read-only.");
                    }
                };
            }
        };
    }
}

