/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.iterables;

import com.github.rjeschke.neetutils.iterables.AbstractXIterable;
import java.util.Iterator;

class XIterableConcat<A>
extends AbstractXIterable<A> {
    private final Iterable<? extends A> iterableA;
    private final Iterable<? extends A> iterableB;

    public XIterableConcat(Iterable<? extends A> iterableA, Iterable<? extends A> iterableB) {
        this.iterableA = iterableA;
        this.iterableB = iterableB;
    }

    @Override
    public Iterator<A> iterator() {
        return new XIterator<A>(this.iterableA.iterator(), this.iterableB.iterator());
    }

    private static final class XIterator<A>
    implements Iterator<A> {
        private final Iterator<? extends A> iteratorA;
        private final Iterator<? extends A> iteratorB;
        private boolean first = true;

        public XIterator(Iterator<? extends A> iteratorA, Iterator<? extends A> iteratorB) {
            this.iteratorA = iteratorA;
            this.iteratorB = iteratorB;
        }

        @Override
        public boolean hasNext() {
            if (this.first) {
                if (this.iteratorA.hasNext()) {
                    return true;
                }
                this.first = false;
            }
            return this.iteratorB.hasNext();
        }

        @Override
        public A next() {
            return this.first ? this.iteratorA.next() : this.iteratorB.next();
        }

        @Override
        public void remove() {
            throw new IllegalStateException("XIterators are read-only.");
        }
    }
}

