/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.iterables;

import com.github.rjeschke.neetutils.fn.FnPredicate;
import com.github.rjeschke.neetutils.iterables.AbstractXIterable;
import java.util.Iterator;
import java.util.NoSuchElementException;

class XIterableFilter<A>
extends AbstractXIterable<A> {
    private final Iterable<? extends A> iterable;
    private final FnPredicate<? super A> predicate;

    public XIterableFilter(Iterable<? extends A> iterable, FnPredicate<? super A> predicate) {
        this.iterable = iterable;
        this.predicate = predicate;
    }

    @Override
    public Iterator<A> iterator() {
        return new XIterator<A>(this.iterable.iterator(), this.predicate);
    }

    private static final class XIterator<A>
    implements Iterator<A> {
        private final Iterator<? extends A> iterator;
        private final FnPredicate<? super A> predicate;
        private boolean hasElement = false;
        private A element = null;

        public XIterator(Iterator<? extends A> iterator, FnPredicate<? super A> predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.hasElement) {
                return true;
            }
            while (this.iterator.hasNext()) {
                A a = this.iterator.next();
                if (!this.predicate.applyPredicate(a)) continue;
                this.element = a;
                this.hasElement = true;
                break;
            }
            return this.hasElement;
        }

        @Override
        public A next() {
            if (!this.hasElement) {
                throw new NoSuchElementException();
            }
            A e = this.element;
            this.hasElement = false;
            return e;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("XIterators are read-only.");
        }
    }
}

