/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.iterables;

import com.github.rjeschke.neetutils.collections.Tuple;
import com.github.rjeschke.neetutils.iterables.AbstractXIterable;
import java.util.Iterator;

class XIterableZip<A, B>
extends AbstractXIterable<Tuple<A, B>> {
    private final Iterable<A> iterableA;
    private final Iterable<B> iterableB;

    public XIterableZip(Iterable<A> iterableA, Iterable<B> iterableB) {
        this.iterableA = iterableA;
        this.iterableB = iterableB;
    }

    @Override
    public Iterator<Tuple<A, B>> iterator() {
        return new XIterator<A, B>(this.iterableA.iterator(), this.iterableB.iterator());
    }

    private static final class XIterator<A, B>
    implements Iterator<Tuple<A, B>> {
        private final Iterator<A> iteratorA;
        private final Iterator<B> iteratorB;

        public XIterator(Iterator<A> iteratorA, Iterator<B> iteratorB) {
            this.iteratorA = iteratorA;
            this.iteratorB = iteratorB;
        }

        @Override
        public boolean hasNext() {
            return this.iteratorA.hasNext() && this.iteratorB.hasNext();
        }

        @Override
        public Tuple<A, B> next() {
            return Tuple.of(this.iteratorA.next(), this.iteratorB.next());
        }

        @Override
        public void remove() {
            throw new IllegalStateException("XIterators are read-only.");
        }
    }
}

