/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.json;

import com.github.rjeschke.neetutils.Classes;
import com.github.rjeschke.neetutils.Objects;
import com.github.rjeschke.neetutils.collections.Colls;
import com.github.rjeschke.neetutils.json.JSONEnum;
import com.github.rjeschke.neetutils.json.JSONMarshallable;
import com.github.rjeschke.neetutils.json.JSONTokenizer;
import com.github.rjeschke.neetutils.json.annotations.JSONCatchAllField;
import com.github.rjeschke.neetutils.json.annotations.JSONForceField;
import com.github.rjeschke.neetutils.json.annotations.JSONGenericType;
import com.github.rjeschke.neetutils.json.annotations.JSONIgnoreField;
import com.github.rjeschke.neetutils.json.annotations.JSONObject;
import com.github.rjeschke.neetutils.json.annotations.JSONReadOnlyField;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class JSON {
    private JSON() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final StringBuilder beautify(StringBuilder sb, String json) throws IOException {
        try (StringReader reader = null;){
            reader = new StringReader(json);
            JSONTokenizer tokenizer = new JSONTokenizer(reader);
            tokenizer.next();
            while (tokenizer.getCurrentToken() != JSONTokenizer.Token.EOF) {
                JSON.beautify(sb, 0, tokenizer);
                if (tokenizer.getCurrentToken() == JSONTokenizer.Token.EOF) continue;
                sb.append('\n');
            }
            StringBuilder stringBuilder = sb;
            return stringBuilder;
        }
    }

    public static final String beautify(String json) throws IOException {
        return json == null || json.isEmpty() ? "" : JSON.beautify(new StringBuilder(json.length()), json).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object decode(String string) throws IOException {
        try (StringReader reader = null;){
            reader = new StringReader(string);
            Object object = JSON.decode(reader);
            return object;
        }
    }

    public static final Object decode(Reader reader) throws IOException {
        JSONTokenizer tokenizer = new JSONTokenizer(reader);
        tokenizer.next();
        Object ret = JSON.readObject(tokenizer);
        if (tokenizer.getCurrentToken() != JSONTokenizer.Token.EOF) {
            throw new IOException("Multiple JSON values in string" + tokenizer.getPosition());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends JSONMarshallable> T decodeInto(String string, T object) throws IOException {
        try (StringReader reader = null;){
            reader = new StringReader(string);
            T t = JSON.decodeInto(reader, object);
            return t;
        }
    }

    public static final <T extends JSONMarshallable> T decodeInto(Reader reader, T object) throws IOException {
        Object obj = JSON.decode(reader);
        if (!Objects.isMap(obj)) {
            throw new IOException("JSON value ist not of type 'object'.");
        }
        return JSON.decodeInto(JSON.asMap(obj), object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final <T extends JSONMarshallable> T decodeInto(Map<String, Object> jsonObject, T object) throws IOException {
        Field catchAll = null;
        HashMap<String, Object> rest = new HashMap<String, Object>();
        Class<?> toClass = object.getClass();
        boolean ignoreNull = true;
        int vis = 8;
        if (toClass.isAnnotationPresent(JSONObject.class)) {
            JSONObject v = toClass.getAnnotation(JSONObject.class);
            vis = v.visibility();
            ignoreNull = v.ignoreNull();
        }
        for (Field f : toClass.getDeclaredFields()) {
            if (!f.isAnnotationPresent(JSONCatchAllField.class)) continue;
            catchAll = f;
            break;
        }
        for (Map.Entry<String, Object> e : jsonObject.entrySet()) {
            try {
                Field f = toClass.getDeclaredField(e.getKey());
                if (ignoreNull && e.getValue() == null) continue;
                if (JSON.isFieldVisible(f, vis, false)) {
                    boolean isAccessible = f.isAccessible();
                    f.setAccessible(true);
                    if (f.getType().isEnum()) {
                        Method m;
                        try {
                            m = f.getType().getMethod("fromJSONString", String.class);
                        }
                        catch (NoSuchMethodException ex) {
                            m = f.getType().getMethod("valueOf", String.class);
                        }
                        f.set(object, m.invoke(null, e.getValue().toString()));
                    } else if (Classes.implementsInterface(f.getType(), JSONMarshallable.class)) {
                        f.set(object, JSON.decodeInto(JSON.asMap(e.getValue()), JSON.newJSONInstance(f.getType())));
                    } else if (f.isAnnotationPresent(JSONGenericType.class)) {
                        Method m;
                        Object out;
                        Object in;
                        Class<?> t = f.getAnnotation(JSONGenericType.class).type();
                        if (Classes.implementsInterface(f.getType(), Map.class)) {
                            in = JSON.asMap(e.getValue());
                            out = new HashMap();
                            if (t.isEnum()) {
                                try {
                                    m = t.getMethod("fromJSONString", String.class);
                                }
                                catch (NoSuchMethodException ex) {
                                    m = t.getMethod("valueOf", String.class);
                                }
                                for (Map.Entry e2 : in.entrySet()) {
                                    out.put(e2.getKey(), m.invoke(null, e2.getValue().toString()));
                                }
                            } else {
                                for (Map.Entry e2 : in.entrySet()) {
                                    out.put(e2.getKey(), JSON.decodeInto(JSON.asMap(e2.getValue()), JSON.newJSONInstance(t)));
                                }
                            }
                            f.set(object, out);
                        } else {
                            if (!Classes.implementsInterface(f.getType(), List.class)) throw new IOException("Marshalling for type " + toClass + " failed for '" + e.getKey() + "'");
                            in = JSON.asArray(e.getValue());
                            out = Colls.list();
                            if (t.isEnum()) {
                                try {
                                    m = t.getMethod("fromJSONString", String.class);
                                }
                                catch (NoSuchMethodException ex) {
                                    m = t.getMethod("valueOf", String.class);
                                }
                                Iterator i$ = in.iterator();
                                while (i$.hasNext()) {
                                    Map.Entry o = i$.next();
                                    out.add(m.invoke(null, o.toString()));
                                }
                            } else {
                                Iterator i$ = in.iterator();
                                while (i$.hasNext()) {
                                    Map.Entry o = i$.next();
                                    out.add(JSON.decodeInto(JSON.asMap(o), JSON.newJSONInstance(t)));
                                }
                            }
                            f.set(object, out);
                        }
                    } else {
                        f.set(object, e.getValue());
                    }
                    f.setAccessible(isAccessible);
                    continue;
                }
                rest.put(e.getKey(), e.getValue());
            }
            catch (NoSuchFieldException ex) {
                rest.put(e.getKey(), e.getValue());
            }
            catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new IOException("Marshalling for type " + toClass + " failed for '" + e.getKey() + "'", ex);
            }
        }
        if (catchAll == null) return object;
        try {
            boolean isAccessible = catchAll.isAccessible();
            catchAll.setAccessible(true);
            catchAll.set(object, rest);
            catchAll.setAccessible(isAccessible);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new IOException("Marshalling for type " + toClass + " failed for '" + catchAll.getName() + "'", ex);
        }
    }

    public static final String encode(Object obj) {
        return JSON.encode(new StringBuilder(), obj).toString();
    }

    public static final StringBuilder encode(StringBuilder sb, Object obj) {
        JSON.writeObject(sb, obj);
        return sb;
    }

    public static final Map<String, Object> asMap(Object obj) {
        return (Map)obj;
    }

    public static final List<Object> asArray(Object obj) {
        return (List)obj;
    }

    public static final Number asNumber(Object obj) {
        return (Number)obj;
    }

    public static final Boolean asBoolean(Object obj) {
        return (Boolean)obj;
    }

    public static final String escapeString(String value) {
        return JSON.escapeString(new StringBuilder(), value).toString();
    }

    public static final StringBuilder escapeString(StringBuilder sb, String value) {
        block10: for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                default: {
                    if (ch < ' ') {
                        sb.append(String.format("\\u%04x", ch));
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb;
    }

    private static final boolean isPublicVisibility(Field f) {
        return (f.getModifiers() & 1) != 0;
    }

    private static final boolean isPrivateVisibility(Field f) {
        return (f.getModifiers() & 2) != 0;
    }

    private static final boolean isDefaultVisibility(Field f) {
        return (f.getModifiers() & 7) == 0;
    }

    private static final boolean isProtectedVisibility(Field f) {
        return (f.getModifiers() & 4) != 0;
    }

    private static final boolean isFieldVisible(Field f, int vis, boolean read) {
        if (f.isAnnotationPresent(JSONIgnoreField.class)) {
            return false;
        }
        if (f.isAnnotationPresent(JSONForceField.class)) {
            return true;
        }
        if (!read && f.isAnnotationPresent(JSONReadOnlyField.class)) {
            return false;
        }
        if (!read && (f.getModifiers() & 0x18) != 0) {
            return false;
        }
        if ((vis & 1) != 0 && JSON.isPrivateVisibility(f)) {
            return true;
        }
        if ((vis & 2) != 0 && JSON.isDefaultVisibility(f)) {
            return true;
        }
        if ((vis & 4) != 0 && JSON.isProtectedVisibility(f)) {
            return true;
        }
        return (vis & 8) != 0 && JSON.isPublicVisibility(f);
    }

    public static final List<Object> readArray(JSONTokenizer tokenizer) throws IOException {
        List<Object> list = Colls.list();
        while (true) {
            JSONTokenizer.Token t;
            if ((t = tokenizer.getCurrentToken()) == JSONTokenizer.Token.ARRAY_CLOSE) break;
            if (t == JSONTokenizer.Token.EOF) {
                throw new IOException("Unexpected end of string for array" + tokenizer.getPosition());
            }
            list.add(JSON.readObject(tokenizer));
            if (tokenizer.getCurrentToken() != JSONTokenizer.Token.COMMA && tokenizer.getCurrentToken() != JSONTokenizer.Token.ARRAY_CLOSE) {
                throw new IOException("',' or ']' expected" + tokenizer.getPosition());
            }
            if (tokenizer.getCurrentToken() != JSONTokenizer.Token.COMMA) continue;
            tokenizer.next();
        }
        tokenizer.next();
        return list;
    }

    public static final Map<String, Object> readMap(JSONTokenizer tokenizer) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (true) {
            JSONTokenizer.Token t;
            if ((t = tokenizer.getCurrentToken()) == JSONTokenizer.Token.OBJECT_CLOSE) break;
            if (t != JSONTokenizer.Token.STRING) {
                throw new IOException("Object key expected" + tokenizer.getPosition());
            }
            String key = tokenizer.getStringValue();
            if (JSONTokenizer.Token.COLON != tokenizer.next()) {
                throw new IOException("':' expected" + tokenizer.getPosition());
            }
            tokenizer.next();
            map.put(key, JSON.readObject(tokenizer));
            if (tokenizer.getCurrentToken() != JSONTokenizer.Token.COMMA && tokenizer.getCurrentToken() != JSONTokenizer.Token.OBJECT_CLOSE) {
                throw new IOException("',' or '}' expected" + tokenizer.getPosition());
            }
            if (tokenizer.getCurrentToken() != JSONTokenizer.Token.COMMA) continue;
            tokenizer.next();
        }
        tokenizer.next();
        return map;
    }

    public static final Object readObject(JSONTokenizer tokenizer) throws IOException {
        switch (tokenizer.getCurrentToken()) {
            case OBJECT_OPEN: {
                tokenizer.next();
                return JSON.readMap(tokenizer);
            }
            case ARRAY_OPEN: {
                tokenizer.next();
                return JSON.readArray(tokenizer);
            }
            case NULL: {
                tokenizer.next();
                return null;
            }
            case TRUE: {
                tokenizer.next();
                return Boolean.TRUE;
            }
            case FALSE: {
                tokenizer.next();
                return Boolean.FALSE;
            }
            case STRING: {
                tokenizer.next();
                return tokenizer.getStringValue();
            }
            case LONG: {
                tokenizer.next();
                return tokenizer.getLongValue();
            }
            case DOUBLE: {
                tokenizer.next();
                return tokenizer.getDoubleValue();
            }
        }
        throw new IOException("Unexpected token: " + (Object)((Object)tokenizer.getCurrentToken()) + "," + tokenizer.getPosition());
    }

    public static final void writeNumber(StringBuilder sb, long value) {
        sb.append(value);
    }

    public static final void writeNumber(StringBuilder sb, double value) {
        sb.append(value);
    }

    public static final void writeNumber(StringBuilder sb, Number value) {
        if (value instanceof Double || value instanceof Float) {
            JSON.writeNumber(sb, value.doubleValue());
        } else {
            JSON.writeNumber(sb, value.longValue());
        }
    }

    public static final void writeString(StringBuilder sb, String value) {
        sb.append('\"');
        JSON.escapeString(sb, value);
        sb.append('\"');
    }

    public static final void writeList(StringBuilder sb, Collection<?> list) {
        boolean second = false;
        sb.append('[');
        for (Object o : list) {
            if (second) {
                sb.append(',');
            } else {
                second = true;
            }
            JSON.writeObject(sb, o);
        }
        sb.append(']');
    }

    public static final void writeMap(StringBuilder sb, Map<?, ?> map) {
        boolean second = false;
        sb.append('{');
        for (Map.Entry<?, ?> e : map.entrySet()) {
            if (second) {
                sb.append(',');
            } else {
                second = true;
            }
            JSON.writeString(sb, e.getKey().toString());
            sb.append(':');
            JSON.writeObject(sb, e.getValue());
        }
        sb.append('}');
    }

    private static final boolean hasInterface(Class<?> clazz, Class<?> inter) {
        if (clazz == null) {
            return false;
        }
        for (Class<?> c : clazz.getInterfaces()) {
            if (c != inter) continue;
            return true;
        }
        return false;
    }

    private static final void writeMarshallable(StringBuilder sb, Object obj) {
        boolean second = false;
        sb.append('{');
        try {
            Class<?> clazz = obj.getClass();
            do {
                boolean ignoreNull = true;
                int vis = 8;
                if (clazz.isAnnotationPresent(JSONObject.class)) {
                    JSONObject v = clazz.getAnnotation(JSONObject.class);
                    vis = v.visibility();
                    ignoreNull = v.ignoreNull();
                }
                for (Field f : clazz.getDeclaredFields()) {
                    if (!JSON.isFieldVisible(f, vis, true)) continue;
                    boolean isAccessible = f.isAccessible();
                    f.setAccessible(true);
                    Object value = f.get(obj);
                    if (value == null && ignoreNull) continue;
                    if (second) {
                        sb.append(',');
                    } else {
                        second = true;
                    }
                    JSON.writeString(sb, f.getName());
                    sb.append(':');
                    JSON.writeObject(sb, value);
                    f.setAccessible(isAccessible);
                }
            } while (JSON.hasInterface(clazz = clazz.getSuperclass(), JSONMarshallable.class));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to write marshallable of type: " + obj.getClass(), e);
        }
        sb.append('}');
    }

    public static final void writeObject(StringBuilder sb, Object obj) {
        if (obj == null) {
            sb.append("null");
        } else if (obj instanceof JSONMarshallable) {
            JSON.writeMarshallable(sb, obj);
        } else if (obj instanceof Map) {
            JSON.writeMap(sb, (Map)obj);
        } else if (obj instanceof Collection) {
            JSON.writeList(sb, (Collection)obj);
        } else if (obj instanceof Number) {
            JSON.writeNumber(sb, (Number)obj);
        } else if (obj instanceof Boolean) {
            sb.append((Boolean)obj != false ? "true" : "false");
        } else if (obj instanceof JSONEnum) {
            JSON.writeString(sb, ((JSONEnum)obj).toJSONString());
        } else {
            JSON.writeString(sb, obj.toString());
        }
    }

    private static final StringBuilder indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    private static final void beautify(StringBuilder sb, int indent, JSONTokenizer tokenizer) throws IOException {
        switch (tokenizer.getCurrentToken()) {
            case OBJECT_OPEN: {
                sb.append("{\n");
                tokenizer.next();
                while (tokenizer.getCurrentToken() != JSONTokenizer.Token.OBJECT_CLOSE) {
                    if (tokenizer.getCurrentToken() != JSONTokenizer.Token.STRING) {
                        throw new IOException("Object key expected, got: " + (Object)((Object)tokenizer.getCurrentToken()) + "," + tokenizer.getPosition());
                    }
                    JSON.indent(sb, indent + 2);
                    JSON.writeString(sb, tokenizer.getStringValue());
                    sb.append(" : ");
                    tokenizer.next();
                    if (tokenizer.getCurrentToken() != JSONTokenizer.Token.COLON) {
                        throw new IOException("':' expected" + tokenizer.getPosition());
                    }
                    tokenizer.next();
                    JSON.beautify(sb, indent + 2, tokenizer);
                    if (tokenizer.getCurrentToken() == JSONTokenizer.Token.COMMA) {
                        sb.append(',');
                        tokenizer.next();
                    }
                    sb.append('\n');
                }
                JSON.indent(sb, indent).append('}');
                tokenizer.next();
                break;
            }
            case ARRAY_OPEN: {
                sb.append("[\n");
                tokenizer.next();
                while (tokenizer.getCurrentToken() != JSONTokenizer.Token.ARRAY_CLOSE) {
                    JSON.beautify(JSON.indent(sb, indent + 2), indent + 2, tokenizer);
                    if (tokenizer.getCurrentToken() == JSONTokenizer.Token.COMMA) {
                        sb.append(',');
                        tokenizer.next();
                    }
                    sb.append('\n');
                }
                JSON.indent(sb, indent).append(']');
                tokenizer.next();
                break;
            }
            case STRING: {
                JSON.writeString(sb, tokenizer.getStringValue());
                tokenizer.next();
                break;
            }
            case TRUE: {
                sb.append("true");
                tokenizer.next();
                break;
            }
            case FALSE: {
                sb.append("false");
                tokenizer.next();
                break;
            }
            case NULL: {
                sb.append("null");
                tokenizer.next();
                break;
            }
            case DOUBLE: {
                JSON.writeNumber(sb, tokenizer.getDoubleValue());
                tokenizer.next();
                break;
            }
            case LONG: {
                JSON.writeNumber(sb, tokenizer.getLongValue());
                tokenizer.next();
                break;
            }
            default: {
                throw new IOException("Unexpected token: " + (Object)((Object)tokenizer.getCurrentToken()) + "," + tokenizer.getPosition());
            }
        }
    }

    private static final <T extends JSONMarshallable> T newJSONInstance(Class<?> clazz) throws IOException {
        try {
            Method m = clazz.getMethod("createJSONInstance", new Class[0]);
            boolean isAccessible = m.isAccessible();
            m.setAccessible(true);
            Object ret = m.invoke(null, new Object[0]);
            m.setAccessible(isAccessible);
            return (T)((JSONMarshallable)Objects.uncheckedCast(ret));
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                boolean isAccessible = ctor.isAccessible();
                ctor.setAccessible(true);
                Object ret = ctor.newInstance(new Object[0]);
                ctor.setAccessible(isAccessible);
                return (T)((JSONMarshallable)Objects.uncheckedCast(ret));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
                throw new IOException("Marshalling for type " + clazz + " failed", e2);
            }
        }
    }
}

