/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.json;

import java.io.IOException;
import java.io.Reader;

public final class JSONTokenizer {
    private final Reader reader;
    private String stringValue;
    private double doubleValue;
    private long longValue;
    private int current = 32;
    private int column = 1;
    private int row = 0;
    private final StringBuilder stringBuilder = new StringBuilder(32);
    private final StringBuilder stringBuilderTmp = new StringBuilder(4);
    private Token currentToken;

    protected JSONTokenizer(Reader reader) {
        this.reader = reader;
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public Token getCurrentToken() {
        return this.currentToken;
    }

    private int read() throws IOException {
        this.current = this.reader.read();
        switch (this.current) {
            case 10: {
                ++this.row;
                this.column = 0;
                break;
            }
            case 13: {
                break;
            }
            default: {
                ++this.column;
            }
        }
        return this.current;
    }

    public String getPosition() {
        return " at row: " + this.row + ", column: " + this.column;
    }

    private Token readString() throws IOException {
        StringBuilder sb = this.stringBuilder;
        sb.setLength(0);
        this.read();
        while (this.current != -1 && this.current != 34) {
            block1 : switch (this.current) {
                case 92: {
                    this.read();
                    switch (this.current) {
                        case 110: {
                            sb.append('\n');
                            break block1;
                        }
                        case 114: {
                            sb.append('\r');
                            break block1;
                        }
                        case 116: {
                            sb.append('\t');
                            break block1;
                        }
                        case 98: {
                            sb.append('\b');
                            break block1;
                        }
                        case 102: {
                            sb.append('\f');
                            break block1;
                        }
                        case 47: {
                            sb.append('/');
                            break block1;
                        }
                        case 92: {
                            sb.append('\\');
                            break block1;
                        }
                        case 34: {
                            sb.append('\"');
                            break block1;
                        }
                        case 117: {
                            this.stringBuilderTmp.setLength(0);
                            for (int i = 0; i < 4; ++i) {
                                this.stringBuilderTmp.append((char)this.read());
                            }
                            try {
                                sb.append((char)Integer.parseInt(this.stringBuilderTmp.toString(), 16));
                                break block1;
                            }
                            catch (NumberFormatException e) {
                                throw new IOException("Illegal unicode escape sequence" + this.getPosition(), e);
                            }
                        }
                    }
                    throw new IOException("Illegal escape sequence" + this.getPosition());
                }
                default: {
                    sb.append((char)this.current);
                }
            }
            this.read();
        }
        if (this.current != 34) {
            throw new IOException("Unexpected end of data, open string" + this.getPosition());
        }
        this.read();
        this.stringValue = sb.toString();
        return Token.STRING;
    }

    private Token readWord() throws IOException {
        StringBuilder sb = this.stringBuilder;
        sb.setLength(0);
        sb.append((char)this.current);
        while (Character.isLetter((char)this.read())) {
            sb.append((char)this.current);
        }
        String word = sb.toString();
        if (word.equals("true")) {
            return Token.TRUE;
        }
        if (word.equals("false")) {
            return Token.FALSE;
        }
        if (word.equals("null")) {
            return Token.NULL;
        }
        throw new IOException("Syntax error: " + word + "," + this.getPosition());
    }

    private Token readNumber() throws IOException {
        StringBuilder sb = this.stringBuilder;
        boolean isDouble = false;
        sb.setLength(0);
        if (this.current == 45) {
            sb.append('-');
            this.read();
        }
        while (Character.isDigit((char)this.current)) {
            sb.append((char)this.current);
            this.read();
        }
        if (this.current == 46) {
            isDouble = true;
            sb.append('.');
            this.read();
            while (Character.isDigit((char)this.current)) {
                sb.append((char)this.current);
                this.read();
            }
        }
        if (this.current == 101 || this.current == 69) {
            isDouble = true;
            this.read();
            sb.append('e');
            if (this.current == 43 || this.current == 45) {
                sb.append((char)this.current);
                this.read();
            }
            while (Character.isDigit((char)this.current)) {
                sb.append((char)this.current);
                this.read();
            }
        }
        try {
            if (isDouble) {
                this.doubleValue = Double.parseDouble(sb.toString());
                return Token.DOUBLE;
            }
            this.longValue = Long.parseLong(sb.toString());
            return Token.LONG;
        }
        catch (NumberFormatException e) {
            throw new IOException("Syntax error: " + sb.toString() + "," + this.getPosition(), e);
        }
    }

    public Token next() throws IOException {
        while (true) {
            switch (this.current) {
                case -1: {
                    this.currentToken = Token.EOF;
                    return this.currentToken;
                }
                case 123: {
                    this.read();
                    this.currentToken = Token.OBJECT_OPEN;
                    return this.currentToken;
                }
                case 125: {
                    this.read();
                    this.currentToken = Token.OBJECT_CLOSE;
                    return this.currentToken;
                }
                case 91: {
                    this.read();
                    this.currentToken = Token.ARRAY_OPEN;
                    return this.currentToken;
                }
                case 93: {
                    this.read();
                    this.currentToken = Token.ARRAY_CLOSE;
                    return this.currentToken;
                }
                case 44: {
                    this.read();
                    this.currentToken = Token.COMMA;
                    return this.currentToken;
                }
                case 58: {
                    this.read();
                    this.currentToken = Token.COLON;
                    return this.currentToken;
                }
                case 34: {
                    this.currentToken = this.readString();
                    return this.currentToken;
                }
                case 45: {
                    this.currentToken = this.readNumber();
                    return this.currentToken;
                }
            }
            if (!Character.isWhitespace((char)this.current) && !Character.isSpaceChar((char)this.current)) break;
            this.read();
        }
        if (Character.isDigit((char)this.current)) {
            this.currentToken = this.readNumber();
            return this.currentToken;
        }
        if (Character.isLetter((char)this.current)) {
            this.currentToken = this.readWord();
            return this.currentToken;
        }
        throw new IOException("Illegal character: " + this.current + "," + this.getPosition());
    }

    public static enum Token {
        OBJECT_OPEN,
        OBJECT_CLOSE,
        ARRAY_OPEN,
        ARRAY_CLOSE,
        COMMA,
        COLON,
        STRING,
        TRUE,
        FALSE,
        NULL,
        DOUBLE,
        LONG,
        EOF;

    }
}

