/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.math;

public class CatmullRomSpline {
    private double a;
    private double b;
    private double c;
    private double d;

    public CatmullRomSpline(double v0, double v1, double v2, double v3) {
        this.a = 2.0 * v1 * 0.5;
        this.b = (v2 - v0) * 0.5;
        this.c = (2.0 * v0 - 5.0 * v1 + 4.0 * v2 - v3) * 0.5;
        this.d = (3.0 * v1 - 3.0 * v2 + v3 - v0) * 0.5;
    }

    public static double get(double v0, double v1, double v2, double v3, double f) {
        return ((((v3 - 3.0 * v2 + 3.0 * v1 - v0) * f + (2.0 * v0 - 5.0 * v1 + 4.0 * v2 - v3)) * f + (v2 - v0)) * f + 2.0 * v1) * 0.5;
    }

    public static float get(float v0, float v1, float v2, float v3, float f) {
        return ((((v3 - 3.0f * v2 + 3.0f * v1 - v0) * f + (2.0f * v0 - 5.0f * v1 + 4.0f * v2 - v3)) * f + (v2 - v0)) * f + 2.0f * v1) * 0.5f;
    }

    public double get(double f) {
        return ((this.d * f + this.c) * f + this.b) * f + this.a;
    }

    public void normalize() {
        double min = 1.0E9;
        double max = -1.0E9;
        for (int i = 0; i <= 65536; ++i) {
            double v = this.get((double)i / 65536.0);
            min = Math.min(v, min);
            max = Math.max(v, max);
        }
        double w = max - min;
        if (w > 0.0) {
            double scale = 2.0 / w;
            this.a *= scale;
            this.b *= scale;
            this.c *= scale;
            this.d *= scale;
            this.a -= (max + min) * scale * 0.5;
        }
    }
}

