/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.rng;

import com.github.rjeschke.neetutils.rng.AbstractRNG;
import com.github.rjeschke.neetutils.rng.RNGFactory;
import com.github.rjeschke.neetutils.rng.RndLCG;

public class RndCMWC
extends AbstractRNG {
    private int pos = 4095;
    private int accu;
    private final int[] history = new int[4096];

    public RndCMWC() {
        this(RNGFactory.defaultSeed());
    }

    public RndCMWC(long seed) {
        RndLCG rnd = new RndLCG(seed);
        this.accu = rnd.nextInt();
        while (this.accu < 0) {
            this.accu = (int)((long)this.accu + 809430660L);
        }
        while ((long)this.accu > 809430660L) {
            this.accu = (int)((long)this.accu - 809430660L);
        }
        for (int i = 0; i < 4096; ++i) {
            this.history[i] = rnd.nextInt();
        }
    }

    @Override
    public int nextInt() {
        int p = this.pos = this.pos + 1 & 0xFFF;
        long t = 18782L * ((long)this.history[p] & 0xFFFFFFFFL) + (long)this.accu;
        this.accu = (int)(t >> 32);
        int x = (int)t + this.accu;
        if (x < this.accu) {
            ++x;
            ++this.accu;
        }
        this.history[p] = -2 - x;
        return this.history[p];
    }
}

