/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.vectors;

import com.github.rjeschke.neetutils.math.NMath;
import com.github.rjeschke.neetutils.vectors.Vector3d;
import com.github.rjeschke.neetutils.vectors.Vector4d;
import java.nio.DoubleBuffer;

public class Vector2d {
    public double x;
    public double y;

    public Vector2d() {
    }

    public Vector2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2d(double xy) {
        this.x = xy;
        this.y = xy;
    }

    public Vector2d(Vector2d v) {
        this.x = v.x;
        this.y = v.y;
    }

    public static Vector2d of(double x, double y) {
        return new Vector2d(x, y);
    }

    public static Vector2d of(Vector2d v) {
        return new Vector2d(v);
    }

    public Vector2d set(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2d set(double xy) {
        this.x = xy;
        this.y = xy;
        return this;
    }

    public Vector2d set(DoubleBuffer buffer, int offset) {
        this.x = buffer.get(offset);
        this.y = buffer.get(offset + 1);
        return this;
    }

    public Vector2d set(Vector2d v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public Vector2d set(Vector3d v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public Vector2d set(Vector4d v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public Vector2d setIdx(int index, double value) {
        if (index == 0) {
            this.x = value;
        } else {
            this.y = value;
        }
        return this;
    }

    public double get(int index) {
        if (index == 0) {
            return this.x;
        }
        return this.y;
    }

    public Vector2d scale(double f) {
        this.x *= f;
        this.y *= f;
        return this;
    }

    public Vector2d add(Vector2d v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    public Vector2d add(Vector2d v, double scale) {
        this.x += v.x * scale;
        this.y += v.y * scale;
        return this;
    }

    public Vector2d sub(Vector2d v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }

    public Vector2d sub(Vector2d v, double scale) {
        this.x -= v.x * scale;
        this.y -= v.y * scale;
        return this;
    }

    public Vector2d mul(Vector2d v) {
        this.x *= v.x;
        this.y *= v.y;
        return this;
    }

    public Vector2d mul(Vector2d v, double scale) {
        this.x *= v.x * scale;
        this.y *= v.y * scale;
        return this;
    }

    public Vector2d div(Vector2d v) {
        this.x /= v.x;
        this.y /= v.y;
        return this;
    }

    public Vector2d div(Vector2d v, double scale) {
        this.x /= v.x * scale;
        this.y /= v.y * scale;
        return this;
    }

    public Vector2d lerp(Vector2d v, double f) {
        this.x += (v.x - this.x) * f;
        this.y += (v.y - this.y) * f;
        return this;
    }

    public double dot(Vector2d v) {
        return this.x * v.x + this.y * v.y;
    }

    public Vector2d min(Vector2d v) {
        this.x = Math.min(this.x, v.x);
        this.y = Math.min(this.y, v.y);
        return this;
    }

    public double min() {
        return Math.min(this.x, this.y);
    }

    public Vector2d max(Vector2d v) {
        this.x = Math.max(this.x, v.x);
        this.y = Math.max(this.y, v.y);
        return this;
    }

    public double max() {
        return Math.min(this.x, this.y);
    }

    public Vector2d clamp(Vector2d min, Vector2d max) {
        this.x = NMath.clamp(this.x, min.x, max.x);
        this.y = NMath.clamp(this.y, min.y, max.y);
        return this;
    }

    public Vector2d abs() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        return this;
    }

    public Vector2d pow(double value) {
        this.x = Math.pow(this.x, value);
        this.y = Math.pow(this.y, value);
        return this;
    }

    public Vector2d normalize() {
        double len = this.x * this.x + this.y * this.y;
        if (len != 0.0) {
            len = 1.0 / Math.sqrt(len);
            this.x *= len;
            this.y *= len;
        }
        return this;
    }

    public Vector2d negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vector2d swizzle(int a, int b) {
        return Vector2d.of(this.get(a), this.get(b));
    }

    public Vector3d swizzle(int a, int b, int c) {
        return Vector3d.of(this.get(a), this.get(b), this.get(c));
    }

    public Vector4d swizzle(int a, int b, int c, int d) {
        return Vector4d.of(this.get(a), this.get(b), this.get(c), this.get(d));
    }

    public void into(double[] arr, int offset) {
        arr[offset] = this.x;
        arr[offset + 1] = this.y;
    }

    public void into(DoubleBuffer buffer, int offset) {
        buffer.put(offset, this.x);
        buffer.put(offset + 1, this.y);
    }

    public Vector2d clone() {
        return new Vector2d(this.x, this.y);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

