/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.vectors;

import com.github.rjeschke.neetutils.math.NMath;
import com.github.rjeschke.neetutils.vectors.Vector3f;
import com.github.rjeschke.neetutils.vectors.Vector4f;
import java.nio.FloatBuffer;

public class Vector2f {
    public float x;
    public float y;

    public Vector2f() {
    }

    public Vector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2f(float xy) {
        this.x = xy;
        this.y = xy;
    }

    public Vector2f(Vector2f v) {
        this.x = v.x;
        this.y = v.y;
    }

    public static Vector2f of(float x, float y) {
        return new Vector2f(x, y);
    }

    public static Vector2f of(Vector2f v) {
        return new Vector2f(v);
    }

    public Vector2f set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2f set(float xy) {
        this.x = xy;
        this.y = xy;
        return this;
    }

    public Vector2f set(FloatBuffer buffer, int offset) {
        this.x = buffer.get(offset);
        this.y = buffer.get(offset + 1);
        return this;
    }

    public Vector2f set(Vector2f v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public Vector2f set(Vector3f v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public Vector2f set(Vector4f v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public Vector2f setIdx(int index, float value) {
        if (index == 0) {
            this.x = value;
        } else {
            this.y = value;
        }
        return this;
    }

    public float get(int index) {
        if (index == 0) {
            return this.x;
        }
        return this.y;
    }

    public Vector2f scale(float f) {
        this.x *= f;
        this.y *= f;
        return this;
    }

    public Vector2f add(Vector2f v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    public Vector2f add(Vector2f v, float scale) {
        this.x += v.x * scale;
        this.y += v.y * scale;
        return this;
    }

    public Vector2f sub(Vector2f v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }

    public Vector2f sub(Vector2f v, float scale) {
        this.x -= v.x * scale;
        this.y -= v.y * scale;
        return this;
    }

    public Vector2f mul(Vector2f v) {
        this.x *= v.x;
        this.y *= v.y;
        return this;
    }

    public Vector2f mul(Vector2f v, float scale) {
        this.x *= v.x * scale;
        this.y *= v.y * scale;
        return this;
    }

    public Vector2f div(Vector2f v) {
        this.x /= v.x;
        this.y /= v.y;
        return this;
    }

    public Vector2f div(Vector2f v, float scale) {
        this.x /= v.x * scale;
        this.y /= v.y * scale;
        return this;
    }

    public Vector2f lerp(Vector2f v, float f) {
        this.x += (v.x - this.x) * f;
        this.y += (v.y - this.y) * f;
        return this;
    }

    public float dot(Vector2f v) {
        return this.x * v.x + this.y * v.y;
    }

    public Vector2f min(Vector2f v) {
        this.x = Math.min(this.x, v.x);
        this.y = Math.min(this.y, v.y);
        return this;
    }

    public float min() {
        return Math.min(this.x, this.y);
    }

    public Vector2f max(Vector2f v) {
        this.x = Math.max(this.x, v.x);
        this.y = Math.max(this.y, v.y);
        return this;
    }

    public float max() {
        return Math.min(this.x, this.y);
    }

    public Vector2f clamp(Vector2f min, Vector2f max) {
        this.x = NMath.clamp(this.x, min.x, max.x);
        this.y = NMath.clamp(this.y, min.y, max.y);
        return this;
    }

    public Vector2f abs() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        return this;
    }

    public Vector2f pow(double value) {
        this.x = (float)Math.pow(this.x, value);
        this.y = (float)Math.pow(this.y, value);
        return this;
    }

    public Vector2f normalize() {
        float len = this.x * this.x + this.y * this.y;
        if (len != 0.0f) {
            len = (float)(1.0 / Math.sqrt(len));
            this.x *= len;
            this.y *= len;
        }
        return this;
    }

    public Vector2f negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vector2f swizzle(int a, int b) {
        return Vector2f.of(this.get(a), this.get(b));
    }

    public Vector3f swizzle(int a, int b, int c) {
        return Vector3f.of(this.get(a), this.get(b), this.get(c));
    }

    public Vector4f swizzle(int a, int b, int c, int d) {
        return Vector4f.of(this.get(a), this.get(b), this.get(c), this.get(d));
    }

    public void into(float[] arr, int offset) {
        arr[offset] = this.x;
        arr[offset + 1] = this.y;
    }

    public void into(FloatBuffer buffer, int offset) {
        buffer.put(offset, this.x);
        buffer.put(offset + 1, this.y);
    }

    public Vector2f clone() {
        return new Vector2f(this.x, this.y);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

