/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.vectors;

import com.github.rjeschke.neetutils.math.NMath;
import com.github.rjeschke.neetutils.vectors.Vector2d;
import com.github.rjeschke.neetutils.vectors.Vector2i;
import com.github.rjeschke.neetutils.vectors.Vector3d;
import com.github.rjeschke.neetutils.vectors.Vector3i;
import java.nio.IntBuffer;

public class Vector4i {
    public int w;
    public int x;
    public int y;
    public int z;

    public Vector4i() {
    }

    public Vector4i(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4i(int xyzw) {
        this.x = xyzw;
        this.y = xyzw;
        this.z = xyzw;
        this.w = xyzw;
    }

    public Vector4i(Vector2i v, int z, int w) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
        this.w = w;
    }

    public Vector4i(Vector3i v, int w) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = w;
    }

    public static Vector4i of(int x, int y, int z, int w) {
        return new Vector4i(x, y, z, w);
    }

    public static Vector4i of(Vector2i v, int z, int w) {
        return new Vector4i(v, z, w);
    }

    public static Vector4i of(Vector3i v, int w) {
        return new Vector4i(v, w);
    }

    public Vector4i set(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4i set(int xyzw) {
        this.x = xyzw;
        this.y = xyzw;
        this.z = xyzw;
        this.w = xyzw;
        return this;
    }

    public Vector4i set(Vector2i v, int z, int w) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4i set(Vector3i v, int w) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = w;
        return this;
    }

    public Vector4i set(Vector4i v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = v.w;
        return this;
    }

    public Vector4i setIdx(int index, int value) {
        if (index == 0) {
            this.x = value;
        } else if (index == 1) {
            this.y = value;
        } else if (index == 2) {
            this.z = value;
        } else {
            this.w = value;
        }
        return this;
    }

    public int get(int index) {
        if (index == 0) {
            return this.x;
        }
        if (index == 1) {
            return this.y;
        }
        if (index == 2) {
            return this.z;
        }
        return this.w;
    }

    public Vector4i add(Vector4i v) {
        this.w += v.w;
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public Vector4i sub(Vector4i v) {
        this.w -= v.w;
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public Vector4i mul(Vector4i v) {
        this.w *= v.w;
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        return this;
    }

    public Vector4i div(Vector4i v) {
        this.w /= v.w;
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        return this;
    }

    public Vector4i min(Vector4i other) {
        this.x = Math.min(this.x, other.x);
        this.y = Math.min(this.y, other.y);
        this.z = Math.min(this.z, other.z);
        this.w = Math.min(this.w, other.w);
        return this;
    }

    public Vector4i max(Vector4i other) {
        this.x = Math.max(this.x, other.x);
        this.y = Math.max(this.y, other.y);
        this.z = Math.max(this.z, other.z);
        this.w = Math.max(this.w, other.w);
        return this;
    }

    public Vector4i clamp(Vector4i min, Vector4i max) {
        this.x = NMath.clamp(this.x, min.x, max.x);
        this.y = NMath.clamp(this.y, min.y, max.y);
        this.z = NMath.clamp(this.z, min.z, max.z);
        this.w = NMath.clamp(this.w, min.w, max.w);
        return this;
    }

    public Vector2d swizzle(int a, int b) {
        return Vector2d.of(this.get(a), this.get(b));
    }

    public Vector3d swizzle(int a, int b, int c) {
        return Vector3d.of(this.get(a), this.get(b), this.get(c));
    }

    public Vector4i swizzle(int a, int b, int c, int d) {
        return Vector4i.of(this.get(a), this.get(b), this.get(c), this.get(d));
    }

    public void into(int[] arr, int offset) {
        arr[offset] = this.x;
        arr[offset + 1] = this.y;
        arr[offset + 2] = this.z;
        arr[offset + 3] = this.w;
    }

    public void into(IntBuffer buffer, int offset) {
        buffer.put(offset, this.x);
        buffer.put(offset + 1, this.y);
        buffer.put(offset + 2, this.z);
        buffer.put(offset + 3, this.w);
    }

    public Vector2i asVector2() {
        return Vector2i.of(this.x, this.y);
    }

    public Vector3i asVector3() {
        return Vector3i.of(this.x, this.y, this.z);
    }

    public Vector4i clone() {
        return new Vector4i(this.x, this.y, this.z, this.w);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }
}

