/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import crl.android.pdfwriter.Array;
import crl.android.pdfwriter.IndirectObject;
import crl.android.pdfwriter.PDFDocument;
import crl.android.pdfwriter.Page;
import java.util.ArrayList;

public class Pages {
    private PDFDocument mDocument;
    private ArrayList<Page> mPageList;
    private IndirectObject mIndirectObject;
    private Array mMediaBox;
    private Array mKids;

    public Pages(PDFDocument document, int pageWidth, int pageHeight) {
        this.mDocument = document;
        this.mIndirectObject = this.mDocument.newIndirectObject();
        this.mPageList = new ArrayList();
        this.mMediaBox = new Array();
        String[] content = new String[]{"0", "0", Integer.toString(pageWidth), Integer.toString(pageHeight)};
        this.mMediaBox.addItemsFromStringArray(content);
        this.mKids = new Array();
    }

    public IndirectObject getIndirectObject() {
        return this.mIndirectObject;
    }

    public Page newPage(int pageWidth, int pageHeight) {
        Page lPage = new Page(this.mDocument, pageWidth, pageHeight);
        this.mPageList.add(lPage);
        this.mKids.addItem(lPage.getIndirectObject().getIndirectReference());
        return lPage;
    }

    public Page getPageAt(int position) {
        return this.mPageList.get(position);
    }

    public int getCount() {
        return this.mPageList.size();
    }

    public void render() {
        this.mIndirectObject.setDictionaryContent("  /Type /Pages\n  /MediaBox " + this.mMediaBox.toPDFString() + "\n  /Count " + Integer.toString(this.mPageList.size()) + "\n  /Kids " + this.mKids.toPDFString() + "\n");
        for (Page lPage : this.mPageList) {
            lPage.render(this.mIndirectObject.getIndirectReference());
        }
    }
}

