/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import android.graphics.BitmapRegionDecoder;
import crl.android.pdfwriter.Indentifiers;
import crl.android.pdfwriter.PDFDocument;
import crl.android.pdfwriter.XObjectImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JPGXObjectImage
extends XObjectImage {
    private String path;
    private JPGXObjectImageReader objectReader;
    private long objectSize;

    public JPGXObjectImage(PDFDocument document, String path) throws IOException {
        this.path = path;
        this.mDocument = document;
        this.mId = Indentifiers.generateId("" + System.currentTimeMillis());
        this.mName = "/img" + ++this.mImageCount;
        File fd = new File(path);
        this.objectSize = fd.length();
        BitmapRegionDecoder brd = BitmapRegionDecoder.newInstance((String)path, (boolean)false);
        this.mWidth = brd.getWidth();
        this.mHeight = brd.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPGXObjectImage(PDFDocument document, String path, JPGXObjectImageReader objectReader) throws IOException {
        BitmapRegionDecoder brd;
        this.path = path;
        this.objectReader = objectReader;
        this.mDocument = document;
        this.mId = Indentifiers.generateId("" + System.currentTimeMillis());
        this.mName = "/img" + ++this.mImageCount;
        File fd = new File(path);
        this.objectSize = fd.length();
        try (InputStream fileInputStream = objectReader.openInputStream(fd);){
            brd = BitmapRegionDecoder.newInstance((InputStream)fileInputStream, (boolean)false);
        }
        this.mWidth = brd.getWidth();
        this.mHeight = brd.getHeight();
    }

    public long getObjectSize() {
        return this.objectSize;
    }

    @Override
    public void appendToDocument() {
        this.mIndirectObject = this.mDocument.newIndirectObject();
        this.mDocument.includeIndirectObject(this.mIndirectObject);
        this.mIndirectObject.addStreamContent(this);
        this.mIndirectObject.addDictionaryContent(" /Type /XObject\n /Subtype /Image\n /Filter /DCTDecode\n /Width " + this.mWidth + "\n" + " /Height " + this.mHeight + "\n" + " /BitsPerComponent " + Integer.toString(BITSPERCOMPONENT) + "\n" + " /Interpolate " + Boolean.toString(INTERPOLATION) + "\n" + " /ColorSpace " + "/DeviceRGB" + "\n" + " /Length " + 6000000 + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeStream(OutputStream out) throws IOException {
        try (InputStream in = null;){
            int read;
            in = this.objectReader == null ? new FileInputStream(this.path) : this.objectReader.openInputStream(new File(this.path));
            byte[] buffer = new byte[15360];
            while ((read = in.read(buffer)) > -1) {
                out.write(buffer, 0, read);
            }
        }
        return this.objectSize;
    }

    public static interface JPGXObjectImageReader {
        public InputStream openInputStream(File var1);
    }
}

