/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import crl.android.pdfwriter.IndirectObject;
import crl.android.pdfwriter.JPGXObjectImage;
import crl.android.pdfwriter.PDFDocument;
import crl.android.pdfwriter.Page;
import crl.android.pdfwriter.Pages;
import java.io.IOException;
import java.io.OutputStream;

public class PDFWriter {
    private PDFDocument mDocument;
    private IndirectObject mCatalog;
    private Pages mPages;
    private Page mCurrentPage;

    public PDFWriter() {
        this.newDocument(2480, 3508);
    }

    public PDFWriter(int pageWidth, int pageHeight) {
        this.newDocument(pageWidth, pageHeight);
    }

    public void newDocument(int pageWidth, int pageHeight) {
        this.mDocument = new PDFDocument();
        this.mCatalog = this.mDocument.newIndirectObject();
        this.mDocument.includeIndirectObject(this.mCatalog);
        this.mPages = new Pages(this.mDocument, pageWidth, pageHeight);
        this.mDocument.includeIndirectObject(this.mPages.getIndirectObject());
        this.renderCatalog();
    }

    public void setDocumentInfo(String info) {
        this.mDocument.setDocumentInfo(info);
    }

    private void renderCatalog() {
        this.mCatalog.setDictionaryContent("  /Type /Catalog\n  /Pages " + this.mPages.getIndirectObject().getIndirectReference() + "\n");
    }

    public void newPage(int pageWidth, int pageHeight) {
        this.mCurrentPage = this.mPages.newPage(pageWidth, pageHeight);
        this.mDocument.includeIndirectObject(this.mCurrentPage.getIndirectObject());
        this.mPages.render();
    }

    public void setCurrentPage(int pageNumber) {
        this.mCurrentPage = this.mPages.getPageAt(pageNumber);
    }

    public int getPageCount() {
        return this.mPages.getCount();
    }

    public void setFont(String subType, String baseFont) {
        this.mCurrentPage.setFont(subType, baseFont);
    }

    public void setFont(String subType, String baseFont, String encoding) {
        this.mCurrentPage.setFont(subType, baseFont, encoding);
    }

    public void addRawContent(String rawContent) {
        this.mCurrentPage.addRawContent(rawContent);
    }

    public void addText(int leftPosition, int topPositionFromBottom, int fontSize, String text) {
        this.addText(leftPosition, topPositionFromBottom, fontSize, text, "1 0 0 1");
    }

    public void addText(int leftPosition, int topPositionFromBottom, int fontSize, String text, String transformation) {
        this.mCurrentPage.addText(leftPosition, topPositionFromBottom, fontSize, text, transformation);
    }

    public void addLine(int fromLeft, int fromBottom, int toLeft, int toBottom) {
        this.mCurrentPage.addLine(fromLeft, fromBottom, toLeft, toBottom);
    }

    public void addRectangle(int fromLeft, int fromBottom, int toLeft, int toBottom) {
        this.mCurrentPage.addRectangle(fromLeft, fromBottom, toLeft, toBottom);
    }

    public void addJPGImageKeepRatio(int pageWidth, int pageHeight, int rotationDegrees, String path) throws IOException {
        JPGXObjectImage img = new JPGXObjectImage(this.mDocument, path);
        this.addJPGImageKeepRatio(pageWidth, pageHeight, rotationDegrees, img);
    }

    public void addJPGImageKeepRatio(int pageWidth, int pageHeight, int rotationDegrees, String path, JPGXObjectImage.JPGXObjectImageReader objectReader) throws IOException {
        JPGXObjectImage img = new JPGXObjectImage(this.mDocument, path, objectReader);
        this.addJPGImageKeepRatio(pageWidth, pageHeight, rotationDegrees, img);
    }

    private void addJPGImageKeepRatio(int pageWidth, int pageHeight, int rotationDegrees, JPGXObjectImage img) throws IOException {
        float imageWidth = img.getWidth();
        float imageHeight = img.getHeight();
        float imgRatio = imageWidth / imageHeight;
        Matrix boxMatrix = new Matrix();
        boxMatrix.setRotate((float)rotationDegrees);
        RectF box = new RectF(0.0f, 0.0f, (float)pageWidth, (float)pageHeight);
        boxMatrix.mapRect(box);
        float transformedPageWidth = (int)box.width();
        float transformedPageHeight = (int)box.height();
        float boxRatio = transformedPageWidth / transformedPageHeight;
        float ratio = imgRatio > boxRatio ? transformedPageWidth / imageWidth : transformedPageHeight / imageHeight;
        int targetWidth = (int)(imageWidth * ratio);
        int targetHeight = (int)(imageHeight * ratio);
        int fromLeft = (pageWidth - targetWidth) / 2;
        int fromBottom = (pageHeight - targetHeight) / 2;
        this.mCurrentPage.addImage(fromLeft, fromBottom, targetWidth, targetHeight, rotationDegrees, img);
    }

    public void addAnnotation(String text, Rect rect) {
        this.mCurrentPage.addAnnotation(text, rect);
    }

    public String asString() {
        this.mPages.render();
        return this.mDocument.toPDFString();
    }

    public void write(OutputStream out) throws IOException {
        this.mPages.render();
        this.mDocument.write(out);
    }
}

