/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import android.graphics.Matrix;
import android.graphics.Rect;
import crl.android.pdfwriter.Annotation;
import crl.android.pdfwriter.Array;
import crl.android.pdfwriter.IndirectObject;
import crl.android.pdfwriter.PDFDocument;
import crl.android.pdfwriter.XObjectImage;
import java.util.ArrayList;

public class Page {
    private PDFDocument mDocument;
    private IndirectObject mIndirectObject;
    private ArrayList<IndirectObject> mPageFonts;
    private ArrayList<XObjectImage> mXObjects;
    private ArrayList<Annotation> mAnnotations;
    private IndirectObject mPageContents;
    private Array mMediaBox = new Array();

    public Page(PDFDocument document, int pageWidth, int pageHeight) {
        if (pageWidth > 0 && pageWidth > 0) {
            String[] content = new String[]{"0", "0", Integer.toString(pageWidth), Integer.toString(pageHeight)};
            this.mMediaBox.addItemsFromStringArray(content);
        }
        this.mDocument = document;
        this.mIndirectObject = this.mDocument.newIndirectObject();
        this.mPageFonts = new ArrayList();
        this.mXObjects = new ArrayList();
        this.mAnnotations = new ArrayList();
        this.setFont("Type1", "Times-Roman", "WinAnsiEncoding");
        this.mPageContents = this.mDocument.newIndirectObject();
        this.mDocument.includeIndirectObject(this.mPageContents);
    }

    public IndirectObject getIndirectObject() {
        return this.mIndirectObject;
    }

    private String getFontReferences() {
        String result = "";
        if (!this.mPageFonts.isEmpty()) {
            result = "    /Font <<\n";
            int x = 0;
            for (IndirectObject lFont : this.mPageFonts) {
                result = result + "      /F" + Integer.toString(++x) + " " + lFont.getIndirectReference() + "\n";
            }
            result = result + "    >>\n";
        }
        return result;
    }

    private String getAnnotationReferences() {
        String result = "";
        if (!this.mAnnotations.isEmpty()) {
            result = "  /Annots [ ";
            for (Annotation annotation : this.mAnnotations) {
                result = result + annotation.getIndirectObject().getIndirectReference() + " ";
            }
            result = result + "]\n";
        }
        return result;
    }

    private String getXObjectReferences() {
        String result = "";
        if (!this.mXObjects.isEmpty()) {
            result = "    /XObject <<\n";
            for (XObjectImage xObj : this.mXObjects) {
                result = result + "      " + xObj.asXObjectReference() + "\n";
            }
            result = result + "    >>\n";
        }
        return result;
    }

    public void render(String pagesIndirectReference) {
        String mediaBox = this.mMediaBox.hasContent() ? "  /MediaBox " + this.mMediaBox.toPDFString() + "\n" : "";
        this.mIndirectObject.setDictionaryContent("  /Type /Page\n  /Parent " + pagesIndirectReference + "\n" + mediaBox + "  /Resources <<\n" + this.getFontReferences() + this.getXObjectReferences() + "  >>\n" + "  /Contents " + this.mPageContents.getIndirectReference() + "\n" + this.getAnnotationReferences());
    }

    public void setFont(String subType, String baseFont) {
        IndirectObject lFont = this.mDocument.newIndirectObject();
        this.mDocument.includeIndirectObject(lFont);
        lFont.setDictionaryContent("  /Type /Font\n  /Subtype /" + subType + "\n  /BaseFont /" + baseFont + "\n");
        this.mPageFonts.add(lFont);
    }

    public void setFont(String subType, String baseFont, String encoding) {
        IndirectObject lFont = this.mDocument.newIndirectObject();
        this.mDocument.includeIndirectObject(lFont);
        lFont.setDictionaryContent("  /Type /Font\n  /Subtype /" + subType + "\n  /BaseFont /" + baseFont + "\n  /Encoding /" + encoding + "\n");
        this.mPageFonts.add(lFont);
    }

    private void addContent(String content) {
        this.mPageContents.addStreamContent(content);
    }

    public void addRawContent(String rawContent) {
        this.addContent(rawContent);
    }

    public void addText(int leftPosition, int topPositionFromBottom, int fontSize, String text) {
        this.addText(leftPosition, topPositionFromBottom, fontSize, text, "1 0 0 1");
    }

    public void addText(int leftPosition, int topPositionFromBottom, int fontSize, String text, String transformation) {
        this.addContent("BT\n" + transformation + " " + Integer.toString(leftPosition) + " " + Integer.toString(topPositionFromBottom) + " Tm\n" + "/F" + Integer.toString(this.mPageFonts.size()) + " " + Integer.toString(fontSize) + " Tf\n" + "(" + text + ") Tj\n" + "ET\n");
    }

    public void addLine(int fromLeft, int fromBottom, int toLeft, int toBottom) {
        this.addContent(Integer.toString(fromLeft) + " " + Integer.toString(fromBottom) + " m\n" + Integer.toString(toLeft) + " " + Integer.toString(toBottom) + " l\nS\n");
    }

    public void addRectangle(int fromLeft, int fromBottom, int toLeft, int toBottom) {
        this.addContent(Integer.toString(fromLeft) + " " + Integer.toString(fromBottom) + " " + Integer.toString(toLeft) + " " + Integer.toString(toBottom) + " re\nS\n");
    }

    private String ensureXObjectImage(XObjectImage xObject) {
        for (XObjectImage x : this.mXObjects) {
            if (!x.getId().equals(xObject.getId())) continue;
            return x.getName();
        }
        this.mXObjects.add(xObject);
        xObject.appendToDocument();
        return xObject.getName();
    }

    public void addImage(int translationX, int translationY, int width, int height, int rotationDegrees, XObjectImage xImage) {
        Matrix translationMatrix = new Matrix();
        translationMatrix.setTranslate((float)translationX, (float)translationY);
        Matrix rotationMatrix = new Matrix();
        rotationMatrix.setRotate((float)rotationDegrees, (float)(width / 2), (float)(height / 2));
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale((float)width, (float)height);
        String name = this.ensureXObjectImage(xImage);
        this.addContent("q\n" + this.toPdfMatrix(translationMatrix) + " cm\n" + this.toPdfMatrix(rotationMatrix) + " cm\n" + this.toPdfMatrix(scaleMatrix) + " cm\n" + name + " Do\n" + "Q\n");
    }

    private String toPdfMatrix(Matrix matrix) {
        float[] points = new float[9];
        matrix.getValues(points);
        return (int)points[0] + " " + (int)points[3] + " " + (int)points[1] + " " + (int)points[4] + " " + (int)points[2] + " " + (int)points[5];
    }

    public void addAnnotation(String text, Rect rect) {
        Annotation annotation = new Annotation(text, rect, this.mDocument);
        this.mAnnotations.add(annotation);
    }
}

