/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.common.animation;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import androidx.compose.runtime.internal.StabilityInferred;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.ui.camera.util.PreviewImageUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0019\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lio/scanbot/sdk/ui_v2/common/animation/CustomBitmapFrameHandler;", "Lio/scanbot/sdk/camera/FrameHandler;", "flow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Landroid/graphics/Bitmap;", "(Lkotlinx/coroutines/flow/MutableStateFlow;)V", "getFlow", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "value", "", "showBitmap", "getShowBitmap", "()Z", "setShowBitmap", "(Z)V", "handleFrame", "previewFrame", "Lio/scanbot/sdk/camera/FrameHandler$Frame;", "rtu-ui-v2-common_release"})
@StabilityInferred(parameters=0)
public final class CustomBitmapFrameHandler
extends FrameHandler {
    @NotNull
    private final MutableStateFlow<Bitmap> flow;
    private boolean showBitmap;
    public static final int $stable = 8;

    public CustomBitmapFrameHandler(@NotNull MutableStateFlow<Bitmap> flow) {
        Intrinsics.checkNotNullParameter(flow, (String)"flow");
        this.flow = flow;
    }

    @NotNull
    public final MutableStateFlow<Bitmap> getFlow() {
        return this.flow;
    }

    public final boolean getShowBitmap() {
        return this.showBitmap;
    }

    public final void setShowBitmap(boolean value) {
        this.showBitmap = value;
        if (!value) {
            this.flow.setValue(null);
        }
    }

    public boolean handleFrame(@NotNull FrameHandler.Frame previewFrame) {
        Intrinsics.checkNotNullParameter((Object)previewFrame, (String)"previewFrame");
        if (this.showBitmap && this.flow.getValue() == null) {
            Bitmap bitmap = PreviewImageUtil.convertNV21ToBitmap$default((byte[])previewFrame.getFrame(), (int)previewFrame.getWidth(), (int)previewFrame.getHeight(), (int)0, (int)8, null);
            Matrix matrix = new Matrix();
            matrix.postRotate((float)previewFrame.getFrameOrientation());
            Bitmap bitmap2 = (Bitmap)this.flow.getValue();
            if (bitmap2 != null) {
                bitmap2.recycle();
            }
            this.flow.setValue((Object)Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true));
        }
        return false;
    }
}

