/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.fileio;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import io.scanbot.common.Result;
import io.scanbot.common.ResultKt;
import io.scanbot.sdk.exceptions.crypto.SourceFileDoesNotExistException;
import io.scanbot.sdk.image.EncodeImageOptions;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u00101\u001a\u00020,\u00a2\u0006\u0004\b<\u0010=J/\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0011J#\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0019J\u0019\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0012\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010 \u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b \u0010!J\u001f\u0010\"\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\"\u0010!J\u001f\u0010#\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b#\u0010!J\u0017\u0010&\u001a\u00020%2\u0006\u0010$\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010*\u001a\u00020)2\u0006\u0010(\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b*\u0010+R\u0017\u00101\u001a\u00020,8\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R\u001a\u00107\u001a\u0002028\u0016X\u0096D\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106R\u0014\u0010;\u001a\u0002088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:\u00a8\u0006>"}, d2={"Lio/scanbot/sdk/persistence/fileio/DefaultFileIOProcessor;", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "Landroid/graphics/Bitmap;", "bitmap", "Landroid/graphics/Bitmap$CompressFormat;", "compressFormat", "", "quality", "Ljava/io/File;", "destination", "", "writeImage", "(Landroid/graphics/Bitmap;Landroid/graphics/Bitmap$CompressFormat;ILjava/io/File;)V", "Lio/scanbot/sdk/image/ImageRef;", "image", "Lio/scanbot/sdk/image/EncodeImageOptions;", "encodeImageOptions", "(Lio/scanbot/sdk/image/ImageRef;Lio/scanbot/sdk/image/EncodeImageOptions;Ljava/io/File;)V", "source", "Landroid/graphics/BitmapFactory$Options;", "options", "readImage", "(Ljava/io/File;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", "Landroid/net/Uri;", "sourceUri", "(Landroid/net/Uri;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", "", "read", "(Ljava/io/File;)[B", "byteArray", "write", "([BLjava/io/File;)V", "copyRaw", "(Ljava/io/File;Ljava/io/File;)V", "copy", "move", "destinationFile", "Ljava/io/OutputStream;", "openFileOutputStream", "(Ljava/io/File;)Ljava/io/OutputStream;", "sourceFile", "Ljava/io/InputStream;", "openFileInputStream", "(Ljava/io/File;)Ljava/io/InputStream;", "Landroid/content/Context;", "a", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "context", "", "b", "Z", "getUseEncryption", "()Z", "useEncryption", "Lio/scanbot/sdk/util/log/Logger;", "c", "Lio/scanbot/sdk/util/log/Logger;", "logger", "<init>", "(Landroid/content/Context;)V", "sdk-base_release"})
public final class DefaultFileIOProcessor
implements FileIOProcessor {
    @NotNull
    public final Context a;
    public final boolean b;
    @NotNull
    public final Logger c;

    /*
     * WARNING - void declaration
     */
    public DefaultFileIOProcessor(@NotNull Context context) {
        void var1_1;
        DefaultFileIOProcessor defaultFileIOProcessor = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        defaultFileIOProcessor.a = var1_1;
        defaultFileIOProcessor.c = LoggerProvider.getLogger();
    }

    @NotNull
    public final Context getContext() {
        return this.a;
    }

    @Override
    public boolean getUseEncryption() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeImage(@NotNull Bitmap bitmap, @NotNull Bitmap.CompressFormat compressFormat, int quality, @NotNull File destination) {
        FileOutputStream fileOutputStream;
        void var4_4;
        void var2_2;
        Throwable throwable;
        File file = destination;
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"compressFormat");
        Intrinsics.checkNotNullParameter((Object)file, (String)"destination");
        if (file.exists()) {
            var4_4.delete();
        }
        FileOutputStream fileOutputStream2 = fileOutputStream;
        void v2 = throwable;
        fileOutputStream2((File)var4_4);
        throwable = null;
        try {
            void var3_3;
            v2.compress((Bitmap.CompressFormat)var2_2, (int)var3_3, (OutputStream)fileOutputStream2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            try {
                throw throwable2;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally((Closeable)fileOutputStream2, (Throwable)throwable);
                throw throwable3;
            }
        }
        CloseableKt.closeFinally((Closeable)fileOutputStream, (Throwable)throwable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeImage(@NotNull ImageRef image, @NotNull EncodeImageOptions encodeImageOptions, @NotNull File destination) {
        void var3_3;
        void var2_2;
        void var1_1;
        File file = destination;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"image");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"encodeImageOptions");
        Intrinsics.checkNotNullParameter((Object)file, (String)"destination");
        if (file.exists()) {
            var3_3.delete();
        }
        this.write((byte[])ResultKt.getOrThrow((Result)var1_1.encodeImage((EncodeImageOptions)var2_2)), (File)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Bitmap readImage(@NotNull File source, @Nullable BitmapFactory.Options options) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"source");
        Uri uri = Uri.fromFile((File)v0);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(...)");
        return this.readImage(uri, (BitmapFactory.Options)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Bitmap readImage(@NotNull Uri sourceUri, @Nullable BitmapFactory.Options options) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sourceUri, (String)"sourceUri");
        if (new File(var1_1.getPath()).exists()) {
            void var2_2;
            return BitmapFactory.decodeFile((String)var1_1.getPath(), (BitmapFactory.Options)var2_2);
        }
        throw new SourceFileDoesNotExistException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public byte[] read(@NotNull File source) {
        File file = source;
        Intrinsics.checkNotNullParameter((Object)file, (String)"source");
        if (file.exists()) {
            void var1_1;
            return FilesKt.readBytes((File)var1_1);
        }
        throw new SourceFileDoesNotExistException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull byte[] byteArray, @NotNull File destination) {
        void var2_2;
        void var1_1;
        File file = destination;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)file, (String)"destination");
        if (file.exists()) {
            var2_2.delete();
        }
        FilesKt.writeBytes((File)var2_2, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void copyRaw(@NotNull File source, @NotNull File destination) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"source");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"destination");
        if (source.exists()) {
            FilesKt.copyTo$default((File)var1_1, (File)var2_2, (boolean)true, (int)0, (int)4, null);
            return;
        }
        throw new SourceFileDoesNotExistException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void copy(@NotNull File source, @NotNull File destination) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"source");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"destination");
        this.copyRaw((File)var1_1, (File)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void move(@NotNull File source, @NotNull File destination) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"source");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"destination");
        this.copy((File)var1_1, (File)var2_2);
        source.delete();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OutputStream openFileOutputStream(@NotNull File destinationFile) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)destinationFile, (String)"destinationFile");
        return new FileOutputStream((File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public InputStream openFileInputStream(@NotNull File sourceFile) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return new FileInputStream((File)var1_1);
    }
}

