/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.barcode.batch;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.widget.LinearLayout;
import androidx.activity.ComponentActivity;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ViewModelLazy;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import io.scanbot.sdk.barcode.entity.BarcodeItem;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.FormattedBarcodeDataMapper;
import io.scanbot.sdk.base.R;
import io.scanbot.sdk.ui.ScanbotActivityResult;
import io.scanbot.sdk.ui.barcode.R;
import io.scanbot.sdk.ui.camera.FinderOverlayView;
import io.scanbot.sdk.ui.camera.FinderOverlayViewKt;
import io.scanbot.sdk.ui.utils.CommonNavigationEvent;
import io.scanbot.sdk.ui.utils.Event;
import io.scanbot.sdk.ui.view.barcode.BarcodeCameraView;
import io.scanbot.sdk.ui.view.barcode.BarcodeCameraViewModel;
import io.scanbot.sdk.ui.view.barcode.BarcodeNavigationEvents;
import io.scanbot.sdk.ui.view.barcode.BaseBarcodeScannerActivity;
import io.scanbot.sdk.ui.view.barcode.BatchBarcodeNavEvent;
import io.scanbot.sdk.ui.view.barcode.batch.BatchBarcodeListView;
import io.scanbot.sdk.ui.view.barcode.batch.BatchBarcodeListViewModel;
import io.scanbot.sdk.ui.view.barcode.batch.configuration.BatchBarcodeCameraConfigurationHelper;
import io.scanbot.sdk.ui.view.barcode.batch.configuration.BatchBarcodeScannerConfiguration;
import io.scanbot.sdk.ui.view.barcode.batch.configuration.json.BatchBarcodeScannerJsonConfiguration;
import io.scanbot.sdk.ui.view.barcode.batch.configuration.json.BatchBarcodeScannerNativeConfiguration;
import io.scanbot.sdk.ui.view.base.PermissionEvents;
import java.io.Serializable;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u0000 *2\u00020\u0001:\u0003*+,B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0012\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\u0016\u0010\u0019\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\b\u0010\u001a\u001a\u00020\u000eH\u0016J+\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0016\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u000eH\u0014J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010)\u001a\u00020\u001dH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006-"}, d2={"Lio/scanbot/sdk/ui/view/barcode/batch/InternalBatchBarcodeScannerActivity;", "Lio/scanbot/sdk/ui/view/barcode/BaseBarcodeScannerActivity;", "()V", "batchBarcodeCameraConfigurationHelper", "Lio/scanbot/sdk/ui/view/barcode/batch/configuration/BatchBarcodeCameraConfigurationHelper;", "batchBarcodeListView", "Lio/scanbot/sdk/ui/view/barcode/batch/BatchBarcodeListView;", "batchBarcodeListViewModel", "Lio/scanbot/sdk/ui/view/barcode/batch/BatchBarcodeListViewModel;", "getBatchBarcodeListViewModel", "()Lio/scanbot/sdk/ui/view/barcode/batch/BatchBarcodeListViewModel;", "batchBarcodeListViewModel$delegate", "Lkotlin/Lazy;", "applyConfiguration", "", "applyDefaultConfiguration", "buildResultIntent", "Landroid/content/Intent;", "barcodes", "", "Lio/scanbot/sdk/barcode/entity/BarcodeItem;", "create", "savedInstanceState", "Landroid/os/Bundle;", "finishCurrentState", "finishWithResult", "onBackPressed", "onRequestPermissionsResult", "requestCode", "", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onResume", "proceedBarcodeNavEvent", "event", "Lio/scanbot/sdk/ui/utils/Event;", "proceedBatchBarcodeNavEvent", "provideLayoutId", "Companion", "InternalResult", "InternalResultContract", "rtu-ui-barcode_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@SourceDebugExtension(value={"SMAP\nInternalBatchBarcodeScannerActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalBatchBarcodeScannerActivity.kt\nio/scanbot/sdk/ui/view/barcode/batch/InternalBatchBarcodeScannerActivity\n+ 2 ActivityViewModelLazy.kt\nandroidx/activity/ActivityViewModelLazyKt\n*L\n1#1,208:1\n43#2,5:209\n*S KotlinDebug\n*F\n+ 1 InternalBatchBarcodeScannerActivity.kt\nio/scanbot/sdk/ui/view/barcode/batch/InternalBatchBarcodeScannerActivity\n*L\n38#1:209,5\n*E\n"})
public abstract class InternalBatchBarcodeScannerActivity
extends BaseBarcodeScannerActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BatchBarcodeCameraConfigurationHelper batchBarcodeCameraConfigurationHelper = new BatchBarcodeCameraConfigurationHelper();
    @NotNull
    private final Lazy batchBarcodeListViewModel$delegate;
    private BatchBarcodeListView batchBarcodeListView;
    @NotNull
    public static final String FORMATTED_DATA_MAPPER = "FORMATTED_DATA_MAPPER";
    public static final int DISABLED_SUBMIT_ALPHA = 100;
    private static final long BATCH_BARCODE_DEFAULT_DETECTION_INTERVAL = 0L;

    /*
     * WARNING - void declaration
     */
    public InternalBatchBarcodeScannerActivity() {
        void $this$viewModels$iv;
        ComponentActivity componentActivity = (ComponentActivity)this;
        Function0 factoryProducer$iv = (Function0)new Function0<ViewModelProvider.Factory>(this){
            final /* synthetic */ InternalBatchBarcodeScannerActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                return this.this$0.getFactory();
            }
        };
        boolean $i$f$viewModels = false;
        Function0 factoryPromise$iv = factoryProducer$iv;
        this.batchBarcodeListViewModel$delegate = (Lazy)new ViewModelLazy(Reflection.getOrCreateKotlinClass(BatchBarcodeListViewModel.class), (Function0)new Function0<ViewModelStore>((ComponentActivity)$this$viewModels$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = componentActivity;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = this.$this_viewModels.getViewModelStore();
                Intrinsics.checkNotNullExpressionValue((Object)viewModelStore, (String)"viewModelStore");
                return viewModelStore;
            }
        }, factoryPromise$iv);
    }

    private final BatchBarcodeListViewModel getBatchBarcodeListViewModel() {
        Lazy lazy = this.batchBarcodeListViewModel$delegate;
        return (BatchBarcodeListViewModel)lazy.getValue();
    }

    protected void create(@Nullable Bundle savedInstanceState) {
        Bundle bundle = this.getIntent().getBundleExtra("CUSTOM_CONFIGURATION");
        if (bundle != null) {
            Bundle bundle2;
            Bundle bundle3 = bundle2 = bundle;
            boolean bl = false;
            BatchBarcodeScannerJsonConfiguration batchBarcodeScannerJsonConfiguration = (BatchBarcodeScannerJsonConfiguration)bundle3.getParcelable("CUSTOM_CONFIGURATION");
            if (batchBarcodeScannerJsonConfiguration != null) {
                BatchBarcodeScannerJsonConfiguration batchBarcodeScannerJsonConfiguration2;
                BatchBarcodeScannerJsonConfiguration jsonConfig = batchBarcodeScannerJsonConfiguration2 = batchBarcodeScannerJsonConfiguration;
                boolean bl2 = false;
                BatchBarcodeScannerNativeConfiguration nativeConfig = (BatchBarcodeScannerNativeConfiguration)bundle3.getParcelable("NATIVE_CUSTOM_CONFIGURATION");
                this.batchBarcodeCameraConfigurationHelper.setConfiguration(jsonConfig, nativeConfig);
            }
        }
        super.onCreate(savedInstanceState);
        View view = this.findViewById(R.id.barcodeCameraView);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.setBarcodeCameraView((BarcodeCameraView)view);
        View view2 = this.findViewById(R.id.batchBarcodeListView);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.batchBarcodeListView = (BatchBarcodeListView)view2;
        this.getBarcodeCameraView().initCameraView$rtu_ui_barcode_release(this.getCameraUiSettings());
        View view3 = this.findViewById(R.id.finder_overlay);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(...)");
        FinderOverlayView finderOverlayView = (FinderOverlayView)view3;
        BatchBarcodeListView batchBarcodeListView = this.batchBarcodeListView;
        if (batchBarcodeListView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"batchBarcodeListView");
            batchBarcodeListView = null;
        }
        LinearLayout linearLayout = batchBarcodeListView.getListBinding$rtu_ui_barcode_release().batchBarcodeBottomSheet;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"batchBarcodeBottomSheet");
        FinderOverlayViewKt.setViewAsBottomSafeArea((FinderOverlayView)finderOverlayView, (View)((View)linearLayout));
        this.applyConfiguration();
        this.getCameraViewModel().setAutoStopOnSuccess(false);
        this.getBarcodeCameraView().setBarcodeHighlightedDelegate(this.getBatchBarcodeListViewModel().getHighlightDelegate());
        BatchBarcodeListView batchBarcodeListView2 = this.batchBarcodeListView;
        if (batchBarcodeListView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"batchBarcodeListView");
            batchBarcodeListView2 = null;
        }
        batchBarcodeListView2.attachViewModel(this.getBatchBarcodeListViewModel());
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)this.getBatchBarcodeListViewModel().getNavEvents()), (Function2)((Function2)new Function2<Event, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ InternalBatchBarcodeScannerActivity this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Event it = (Event)this.L$0;
                        InternalBatchBarcodeScannerActivity.access$proceedBatchBarcodeNavEvent(this.this$0, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Event p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))));
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)this.getCameraViewModel().getNavEvents()), (Function2)((Function2)new Function2<Event, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ InternalBatchBarcodeScannerActivity this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Event it = (Event)this.L$0;
                        InternalBatchBarcodeScannerActivity.access$proceedBarcodeNavEvent(this.this$0, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Event p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))));
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)this.getPermissionViewModel().getNavEvents()), (Function2)((Function2)new Function2<Event, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ InternalBatchBarcodeScannerActivity this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Event it = (Event)this.L$0;
                        InternalBatchBarcodeScannerActivity.access$proceedBarcodeNavEvent(this.this$0, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Event p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))));
    }

    @Override
    public int provideLayoutId() {
        return R.layout.scanbot_sdk_activity_batch_barcode_camera;
    }

    private final void applyConfiguration() {
        this.applyDefaultConfiguration();
        BarcodeCameraView barcodeCameraView = this.getBarcodeCameraView();
        BarcodeCameraViewModel barcodeCameraViewModel = this.getCameraViewModel();
        BatchBarcodeListViewModel batchBarcodeListViewModel2 = this.getBatchBarcodeListViewModel();
        BatchBarcodeListView batchBarcodeListView = this.batchBarcodeListView;
        if (batchBarcodeListView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"batchBarcodeListView");
            batchBarcodeListView = null;
        }
        this.batchBarcodeCameraConfigurationHelper.applyConfigurationValue(barcodeCameraView, barcodeCameraViewModel, batchBarcodeListViewModel2, batchBarcodeListView, (Context)this);
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (this.batchBarcodeCameraConfigurationHelper.isPlaySuccessBeep()) {
            this.getBeeper().setBleepEnabled(true);
        }
    }

    public void onBackPressed() {
        BatchBarcodeListView batchBarcodeListView = this.batchBarcodeListView;
        if (batchBarcodeListView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"batchBarcodeListView");
            batchBarcodeListView = null;
        }
        if (!batchBarcodeListView.onBackPressed()) {
            super.onBackPressed();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 2726) {
            this.getPermissionViewModel().cameraPermissionChanged();
        }
    }

    public void finishCurrentState() {
        super.finishCurrentState();
        this.getBatchBarcodeListViewModel().onFinishCurrentState();
    }

    private final void applyDefaultConfiguration() {
        this.getBarcodeCameraView().setSuccessfulDetectionInterval(0L);
    }

    private final Intent buildResultIntent(List<BarcodeItem> barcodes) {
        Intent intent = new Intent();
        intent.putExtra("rtuResult", (Parcelable)new BarcodeScanningResult(barcodes, 0L, 2, null));
        return intent;
    }

    private final void finishWithResult(List<BarcodeItem> barcodes) {
        this.setResult(-1, this.buildResultIntent(barcodes));
        this.finish();
    }

    private final void proceedBatchBarcodeNavEvent(Event event) {
        Event event2 = event;
        if (event2 instanceof BatchBarcodeNavEvent.BarcodesScanFinished) {
            this.finishWithResult(((BatchBarcodeNavEvent.BarcodesScanFinished)event).getBarcodes());
        } else if (Intrinsics.areEqual((Object)event2, (Object)BatchBarcodeNavEvent.NewBarcodesProcessed.INSTANCE)) {
            this.getBeeper().playBleepSound();
        }
    }

    private final void proceedBarcodeNavEvent(Event event) {
        Event event2 = event;
        if (!(event2 instanceof BarcodeNavigationEvents.BarcodeScanned)) {
            if (event2 instanceof BarcodeNavigationEvents.BarcodesSelected) {
                this.getBatchBarcodeListViewModel().onBarcodeSelected(((BarcodeNavigationEvents.BarcodesSelected)event).getSelected(), ((BarcodeNavigationEvents.BarcodesSelected)event).getAutomaticSelection());
            } else if (Intrinsics.areEqual((Object)event2, (Object)CommonNavigationEvent.Cancel.INSTANCE)) {
                this.onCancelScanning();
            } else if (Intrinsics.areEqual((Object)event2, (Object)CommonNavigationEvent.InvalidLicense.INSTANCE)) {
                this.onCancelScanningLicenseInvalid();
            } else if (Intrinsics.areEqual((Object)event2, (Object)PermissionEvents.RequestCameraPermission.INSTANCE)) {
                this.tryAskCameraPermission();
            } else if (Intrinsics.areEqual((Object)event2, (Object)PermissionEvents.ShowCameraPermissionSetting.INSTANCE)) {
                this.activateCameraPermission();
            } else if (Intrinsics.areEqual((Object)event2, (Object)BarcodeNavigationEvents.SnappingTimeOut.INSTANCE)) {
                this.onSnappingTimeout();
            }
        }
    }

    @JvmStatic
    @NotNull
    public static final <A> Intent newIntentInternal(@NotNull Context context, @NotNull Class<A> activityClass, @NotNull BatchBarcodeScannerConfiguration scannerConfiguration) {
        return Companion.newIntentInternal(context, activityClass, scannerConfiguration);
    }

    public static final /* synthetic */ void access$proceedBatchBarcodeNavEvent(InternalBatchBarcodeScannerActivity $this, Event event) {
        $this.proceedBatchBarcodeNavEvent(event);
    }

    public static final /* synthetic */ void access$proceedBarcodeNavEvent(InternalBatchBarcodeScannerActivity $this, Event event) {
        $this.proceedBarcodeNavEvent(event);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/scanbot/sdk/ui/view/barcode/batch/InternalBatchBarcodeScannerActivity$Companion;", "", "()V", "BATCH_BARCODE_DEFAULT_DETECTION_INTERVAL", "", "DISABLED_SUBMIT_ALPHA", "", "FORMATTED_DATA_MAPPER", "", "newIntentInternal", "Landroid/content/Intent;", "A", "context", "Landroid/content/Context;", "activityClass", "Ljava/lang/Class;", "scannerConfiguration", "Lio/scanbot/sdk/ui/view/barcode/batch/configuration/BatchBarcodeScannerConfiguration;", "rtu-ui-barcode_release"})
    @SourceDebugExtension(value={"SMAP\nInternalBatchBarcodeScannerActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalBatchBarcodeScannerActivity.kt\nio/scanbot/sdk/ui/view/barcode/batch/InternalBatchBarcodeScannerActivity$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1#2:209\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <A> Intent newIntentInternal(@NotNull Context context, @NotNull Class<A> activityClass, @NotNull BatchBarcodeScannerConfiguration scannerConfiguration) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(activityClass, (String)"activityClass");
            Intrinsics.checkNotNullParameter((Object)scannerConfiguration, (String)"scannerConfiguration");
            Intent intent = new Intent(context, activityClass);
            Bundle bundle = new Bundle();
            bundle.putParcelable("CUSTOM_CONFIGURATION", (Parcelable)scannerConfiguration.getParams());
            bundle.putParcelable("NATIVE_CUSTOM_CONFIGURATION", (Parcelable)scannerConfiguration.getNativeParams());
            Class<? extends FormattedBarcodeDataMapper> clazz = scannerConfiguration.getNativeParams().getFormattedDataMapper();
            if (clazz != null) {
                Class<? extends FormattedBarcodeDataMapper> clazz2;
                Class<? extends FormattedBarcodeDataMapper> it = clazz2 = clazz;
                boolean bl = false;
                intent.putExtra(InternalBatchBarcodeScannerActivity.FORMATTED_DATA_MAPPER, (Serializable)it);
            }
            intent.putExtra("CUSTOM_CONFIGURATION", bundle);
            return intent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/ui/view/barcode/batch/InternalBatchBarcodeScannerActivity$InternalResult;", "Lio/scanbot/sdk/ui/ScanbotActivityResult;", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "Lio/scanbot/sdk/ui/view/barcode/BaseBarcodeScannerActivity$AutoCancellableResult;", "rtu-ui-barcode_release"})
    public static interface InternalResult
    extends ScanbotActivityResult<BarcodeScanningResult>,
    BaseBarcodeScannerActivity.AutoCancellableResult {

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static boolean getResultOk(@NotNull InternalResult $this) {
                return ScanbotActivityResult.DefaultImpls.getResultOk((ScanbotActivityResult)$this);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u0011\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J7\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H$\u00a2\u0006\u0002\u0010\u0016J\u001f\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\u0019R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/scanbot/sdk/ui/view/barcode/batch/InternalBatchBarcodeScannerActivity$InternalResultContract;", "R", "Lio/scanbot/sdk/ui/view/barcode/batch/InternalBatchBarcodeScannerActivity$InternalResult;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lio/scanbot/sdk/ui/view/barcode/batch/configuration/BatchBarcodeScannerConfiguration;", "activityClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "instantiateResult", "resultCode", "", "result", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "isLicenseInvalid", "", "sdkIsNotInitialized", "isAutoCancelledByTimeout", "(ILio/scanbot/sdk/barcode/entity/BarcodeScanningResult;ZZZ)Lio/scanbot/sdk/ui/view/barcode/batch/InternalBatchBarcodeScannerActivity$InternalResult;", "parseResult", "intent", "(ILandroid/content/Intent;)Lio/scanbot/sdk/ui/view/barcode/batch/InternalBatchBarcodeScannerActivity$InternalResult;", "rtu-ui-barcode_release"})
    public static abstract class InternalResultContract<R extends InternalResult>
    extends ActivityResultContract<BatchBarcodeScannerConfiguration, R> {
        @NotNull
        private final Class<?> activityClass;

        public InternalResultContract(@NotNull Class<?> activityClass) {
            Intrinsics.checkNotNullParameter(activityClass, (String)"activityClass");
            this.activityClass = activityClass;
        }

        @NotNull
        public Intent createIntent(@NotNull Context context, @NotNull BatchBarcodeScannerConfiguration input) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return Companion.newIntentInternal(context, this.activityClass, input);
        }

        @NotNull
        public R parseResult(int resultCode, @Nullable Intent intent) {
            BarcodeScanningResult barcodeScanningResult;
            if (resultCode == -1 && intent != null) {
                Parcelable parcelable = intent.getParcelableExtra("rtuResult");
                Intrinsics.checkNotNull((Object)parcelable);
                barcodeScanningResult = (BarcodeScanningResult)parcelable;
            } else {
                barcodeScanningResult = null;
            }
            BarcodeScanningResult result = barcodeScanningResult;
            boolean licenceInvalid = resultCode == 501;
            boolean sdkIsNotInitialized = resultCode == 502;
            Intent intent2 = intent;
            boolean autoCancelFlag = intent2 != null ? intent2.getBooleanExtra("CANCELLATION_REASON_TIMEOUT", false) : false;
            return this.instantiateResult(resultCode, result, licenceInvalid, sdkIsNotInitialized, autoCancelFlag);
        }

        @NotNull
        protected abstract R instantiateResult(int var1, @Nullable BarcodeScanningResult var2, boolean var3, boolean var4, boolean var5);
    }
}

