/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.barcode;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import androidx.activity.result.contract.ActivityResultContract;
import io.scanbot.sap.SdkLicenseInfo;
import io.scanbot.sap.Status;
import io.scanbot.sdk.barcode_scanner.ScanbotBarcodeScannerSDKInitializer;
import io.scanbot.sdk.ui.barcode_scanner.view.barcode.BarcodeScannerActivity;
import io.scanbot.sdk.ui.barcode_scanner.view.barcode.batch.BatchBarcodeScannerActivity;
import io.scanbot.sdk.ui.view.barcode.InternalBarcodeScannerActivity;
import io.scanbot.sdk.ui.view.barcode.batch.InternalBatchBarcodeScannerActivity;
import io.scanbot.sdk.ui.view.barcode.batch.configuration.BatchBarcodeScannerConfiguration;
import io.scanbot.sdk.ui.view.barcode.configuration.BarcodeScannerConfiguration;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.barcode.SBBWrapper;
import io.scanbot.sdk_wrapper.barcode.SBBWrapperOperations;
import io.scanbot.sdk_wrapper.barcode.SBWrapperOperations;
import io.scanbot.sdk_wrapper.barcode.extensions.SBBWrapperScanbotBarcodeScannerSDKInitializerExtensionKt;
import io.scanbot.sdk_wrapper.exceptions.SBWrapperExceptions;
import io.scanbot.sdk_wrapper.interfaces.SBWrapperResultDelegate;
import io.scanbot.sdk_wrapper.utils.SBWrapperSDKChecks;
import io.scanbot.sdk_wrapper.utils.SBWrapperStorageUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0019\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0002\u0010\nJ!\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0002\u0010\u000eJ!\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00122\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u0012\u0010\u0015\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J)\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0002\u0010\u0019J\"\u0010\u001a\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\"\u0010\u001b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u00a8\u0006\u001c"}, d2={"Lio/scanbot/sdk_wrapper/barcode/SBBWrapperOperations;", "", "()V", "checkLicenseAndSendResult", "", "licenseInfo", "Lio/scanbot/sap/SdkLicenseInfo;", "resultDelegate", "Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;", "cleanup", "(Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;)Lkotlin/Unit;", "closeBarcodeScanner", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;)Lkotlin/Unit;", "closeBatchBarcodeScanner", "detectBarcodesOnImage", "configurationAsJSON", "Lorg/json/JSONObject;", "extractImagesFromPDF", "argsAsJSON", "getLicenseInfo", "initializeSdk", "application", "Landroid/app/Application;", "(Landroid/app/Application;Lorg/json/JSONObject;Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;)Lkotlin/Unit;", "startBarcodeScanner", "startBatchBarcodeScanner", "barcode-sdk-wrapper_release"})
public final class SBBWrapperOperations {
    @NotNull
    public static final SBBWrapperOperations INSTANCE = new SBBWrapperOperations();

    private SBBWrapperOperations() {
    }

    @JvmStatic
    @Nullable
    public static final Unit initializeSdk(@NotNull Application application, @NotNull JSONObject configurationAsJSON, @Nullable SBWrapperResultDelegate resultDelegate) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)configurationAsJSON, (String)"configurationAsJSON");
        return (Unit)SBWrapperSDKChecks.INSTANCE.sdkFunction(null, resultDelegate, false, false, (Function0)new Function0<Unit>(application, configurationAsJSON, resultDelegate){
            final /* synthetic */ Application $application;
            final /* synthetic */ JSONObject $configurationAsJSON;
            final /* synthetic */ SBWrapperResultDelegate $resultDelegate;
            {
                this.$application = $application;
                this.$configurationAsJSON = $configurationAsJSON;
                this.$resultDelegate = $resultDelegate;
                super(0);
            }

            public final void invoke() {
                File file;
                File file2;
                SBWrapper.INSTANCE.setLoggerTag$barcode_sdk_wrapper_release("ScanbotBarcodeSDKWrapper");
                SBWrapper.INSTANCE.setApplication$barcode_sdk_wrapper_release(this.$application);
                LoggerProvider.getLogger().i(SBWrapper.INSTANCE.getLoggerTag$barcode_sdk_wrapper_release(), "Initializing Scanbot Barcode SDK ...");
                ScanbotBarcodeScannerSDKInitializer scanbotBarcodeScannerSDKInitializer = new ScanbotBarcodeScannerSDKInitializer();
                String string = this.$configurationAsJSON.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configurationAsJSON.toString()");
                ScanbotBarcodeScannerSDKInitializer sdkInitializer = SBBWrapperScanbotBarcodeScannerSDKInitializerExtensionKt.fromJson(scanbotBarcodeScannerSDKInitializer, string);
                SdkLicenseInfo licenseInfo = sdkInitializer.initialize(this.$application);
                File it = SBBWrapper.INSTANCE.getBarcodeScannerSDKBarcodeFileStorage().getBarcodeImagesDirectory();
                boolean bl = false;
                File file3 = file2 = it.getParentFile();
                if (file3 == null) {
                    file = it;
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"it.parentFile ?: it");
                    file = file2;
                }
                SBWrapperStorageUtils.INSTANCE.setBaseDirectory(new File(file, "sbw_storage"));
                SBWrapperSDKChecks.INSTANCE.setInitialized(true);
                SBBWrapperOperations.access$checkLicenseAndSendResult(SBBWrapperOperations.INSTANCE, licenseInfo, this.$resultDelegate);
            }
        });
    }

    @JvmStatic
    public static final void getLicenseInfo(@Nullable SBWrapperResultDelegate resultDelegate) {
        SBWrapperOperations.INSTANCE.getLicenseInfo$barcode_sdk_wrapper_release(SBBWrapper.INSTANCE.getBarcodeScannerSDKLicenseInfo(), resultDelegate);
    }

    @JvmStatic
    public static final void detectBarcodesOnImage(@NotNull JSONObject configurationAsJSON, @Nullable SBWrapperResultDelegate resultDelegate) {
        Intrinsics.checkNotNullParameter((Object)configurationAsJSON, (String)"configurationAsJSON");
        SBWrapperOperations.INSTANCE.detectBarcodesOnImage$barcode_sdk_wrapper_release(SBBWrapper.INSTANCE.getBarcodeScannerSDKLicenseInfo(), configurationAsJSON, resultDelegate, SBBWrapper.INSTANCE.getBarcodeScannerSDKBarcodeDetector());
    }

    @JvmStatic
    public static final void extractImagesFromPDF(@NotNull JSONObject argsAsJSON, @Nullable SBWrapperResultDelegate resultDelegate) {
        Intrinsics.checkNotNullParameter((Object)argsAsJSON, (String)"argsAsJSON");
        SBWrapperOperations.INSTANCE.extractImagesFromPDF$barcode_sdk_wrapper_release(SBBWrapper.INSTANCE.getBarcodeScannerSDKLicenseInfo(), argsAsJSON, resultDelegate, SBBWrapper.INSTANCE.getBarcodeScannerSDKPdfImagesExtractor());
    }

    @JvmStatic
    public static final void startBarcodeScanner(@NotNull Activity activity, @NotNull JSONObject configurationAsJSON, @Nullable SBWrapperResultDelegate resultDelegate) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)configurationAsJSON, (String)"configurationAsJSON");
        SBWrapperOperations.INSTANCE.startBarcodeScanner$barcode_sdk_wrapper_release(activity, SBBWrapper.INSTANCE.getBarcodeScannerSDKLicenseInfo(), configurationAsJSON, resultDelegate, (ActivityResultContract<BarcodeScannerConfiguration, InternalBarcodeScannerActivity.InternalResult>)((ActivityResultContract)new BarcodeScannerActivity.ResultContract()));
    }

    @JvmStatic
    @Nullable
    public static final Unit closeBarcodeScanner(@NotNull Activity activity, @Nullable SBWrapperResultDelegate resultDelegate) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        return (Unit)SBWrapperSDKChecks.sdkFunction$default(SBWrapperSDKChecks.INSTANCE, SBBWrapper.INSTANCE.getBarcodeScannerSDKLicenseInfo(), resultDelegate, false, false, (Function0)new Function0<Unit>(activity, resultDelegate){
            final /* synthetic */ Activity $activity;
            final /* synthetic */ SBWrapperResultDelegate $resultDelegate;
            {
                this.$activity = $activity;
                this.$resultDelegate = $resultDelegate;
                super(0);
            }

            public final void invoke() {
                BarcodeScannerActivity.Companion.forceClose((Context)this.$activity);
                SBWrapperOperations.INSTANCE.setBarcodeScanner$barcode_sdk_wrapper_release(null);
                SBWrapperResultDelegate.Companion.sendSuccessOnMainThread$barcode_sdk_wrapper_release$default(SBWrapperResultDelegate.Companion, this.$resultDelegate, null, null, 4, null);
            }
        }, 12, null);
    }

    @JvmStatic
    public static final void startBatchBarcodeScanner(@NotNull Activity activity, @NotNull JSONObject configurationAsJSON, @Nullable SBWrapperResultDelegate resultDelegate) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)configurationAsJSON, (String)"configurationAsJSON");
        SBWrapperOperations.INSTANCE.startBatchBarcodeScanner$barcode_sdk_wrapper_release(activity, SBBWrapper.INSTANCE.getBarcodeScannerSDKLicenseInfo(), configurationAsJSON, resultDelegate, (ActivityResultContract<BatchBarcodeScannerConfiguration, InternalBatchBarcodeScannerActivity.InternalResult>)((ActivityResultContract)new BatchBarcodeScannerActivity.ResultContract()));
    }

    @JvmStatic
    @Nullable
    public static final Unit closeBatchBarcodeScanner(@NotNull Activity activity, @Nullable SBWrapperResultDelegate resultDelegate) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        return (Unit)SBWrapperSDKChecks.sdkFunction$default(SBWrapperSDKChecks.INSTANCE, SBBWrapper.INSTANCE.getBarcodeScannerSDKLicenseInfo(), resultDelegate, false, false, (Function0)new Function0<Unit>(activity, resultDelegate){
            final /* synthetic */ Activity $activity;
            final /* synthetic */ SBWrapperResultDelegate $resultDelegate;
            {
                this.$activity = $activity;
                this.$resultDelegate = $resultDelegate;
                super(0);
            }

            public final void invoke() {
                BatchBarcodeScannerActivity.Companion.forceClose$default((BatchBarcodeScannerActivity.Companion)BatchBarcodeScannerActivity.Companion, (Context)((Context)this.$activity), (boolean)false, (int)2, null);
                SBWrapperOperations.INSTANCE.setBatchBarcodeScanner$barcode_sdk_wrapper_release(null);
                SBWrapperResultDelegate.Companion.sendSuccessOnMainThread$barcode_sdk_wrapper_release$default(SBWrapperResultDelegate.Companion, this.$resultDelegate, null, null, 4, null);
            }
        }, 12, null);
    }

    @JvmStatic
    @Nullable
    public static final Unit cleanup(@Nullable SBWrapperResultDelegate resultDelegate) {
        return (Unit)SBWrapperSDKChecks.sdkFunction$default(SBWrapperSDKChecks.INSTANCE, SBBWrapper.INSTANCE.getBarcodeScannerSDKLicenseInfo(), resultDelegate, false, false, (Function0)new Function0<Unit>(resultDelegate){
            final /* synthetic */ SBWrapperResultDelegate $resultDelegate;
            {
                this.$resultDelegate = $resultDelegate;
                super(0);
            }

            public final void invoke() {
                LoggerProvider.getLogger().i(SBWrapper.INSTANCE.getLoggerTag$barcode_sdk_wrapper_release(), "Cleaning storage folder ...");
                SBWrapper.INSTANCE.getThreadPool$barcode_sdk_wrapper_release().execute(() -> cleanup.1.invoke$lambda$0(this.$resultDelegate));
            }

            private static final void invoke$lambda$0(SBWrapperResultDelegate $resultDelegate) {
                try {
                    SBBWrapper.INSTANCE.getBarcodeScannerSDKBarcodeFileStorage().cleanupBarcodeImagesDirectory();
                    SBWrapperStorageUtils.INSTANCE.cleanupWrapperStorage();
                    SBWrapperResultDelegate.Companion.sendSuccessOnMainThread$barcode_sdk_wrapper_release$default(SBWrapperResultDelegate.Companion, $resultDelegate, "Cleanup successfully done.", null, 4, null);
                }
                catch (Exception ex) {
                    SBWrapperResultDelegate.Companion.sendFailureOnMainThread$barcode_sdk_wrapper_release($resultDelegate, new SBWrapperExceptions.SBWrapperUnexpectedError(ex.getMessage()));
                }
            }
        }, 12, null);
    }

    private final void checkLicenseAndSendResult(SdkLicenseInfo licenseInfo, SBWrapperResultDelegate resultDelegate) {
        LoggerProvider.getLogger().i(SBWrapper.INSTANCE.getLoggerTag$barcode_sdk_wrapper_release(), "Checking license ...");
        String result = "Scanbot Barcode SDK initialized";
        if (licenseInfo.isValid()) {
            if (licenseInfo.getStatus() == Status.StatusTrial) {
                result = result + " in trial mode. You can now test all features for 60 seconds.";
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(result).append(" with invalid license key. ");
            String string = licenseInfo.getLicenseStatusMessage();
            if (string == null) {
                string = "";
            }
            result = stringBuilder.append(string).toString();
        }
        SBWrapperResultDelegate.Companion.sendSuccessOnMainThread$barcode_sdk_wrapper_release$default(SBWrapperResultDelegate.Companion, resultDelegate, result, null, 4, null);
    }

    public static final /* synthetic */ void access$checkLicenseAndSendResult(SBBWrapperOperations $this, SdkLicenseInfo licenseInfo, SBWrapperResultDelegate resultDelegate) {
        $this.checkLicenseAndSendResult(licenseInfo, resultDelegate);
    }
}

