/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.barcode.common;

import android.graphics.Rect;
import io.scanbot.sdk.barcode.entity.BarcodeItem;
import io.scanbot.sdk.barcode.entity.ResultPoint;
import io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeItemMapper;
import io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeMappedData;
import io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeMappingResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\fH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u0003*\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0004\u001a\u00020\u0005\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"averagePointDistanceToFrameCenter", "", "item", "Lio/scanbot/sdk/barcode/entity/BarcodeItem;", "area", "Landroid/graphics/Rect;", "getUniqueBarcodeUUID", "", "loadData", "Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeMappedData;", "delegate", "Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeItemMapper;", "Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeItem;", "(Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeItemMapper;Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeItem;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFocusedBarcode", "", "rtu-ui-v2-barcode-common_release"})
@SourceDebugExtension(value={"SMAP\nBaseBarcodeViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseBarcodeViewModel.kt\nio/scanbot/sdk/ui_v2/barcode/common/BaseBarcodeViewModelKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,272:1\n2333#2,14:273\n11335#3:287\n11670#3,3:288\n314#4,11:291\n*S KotlinDebug\n*F\n+ 1 BaseBarcodeViewModel.kt\nio/scanbot/sdk/ui_v2/barcode/common/BaseBarcodeViewModelKt\n*L\n245#1:273,14\n250#1:287\n250#1:288,3\n261#1:291,11\n*E\n"})
public final class BaseBarcodeViewModelKt {
    @Nullable
    public static final BarcodeItem getFocusedBarcode(@NotNull List<BarcodeItem> $this$getFocusedBarcode, @NotNull Rect area) {
        Object v0;
        Intrinsics.checkNotNullParameter($this$getFocusedBarcode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        Iterable $this$minByOrNull$iv = $this$getFocusedBarcode;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                BarcodeItem item = (BarcodeItem)minElem$iv;
                boolean bl = false;
                double minValue$iv = BaseBarcodeViewModelKt.averagePointDistanceToFrameCenter(item, area);
                do {
                    Object e$iv = iterator$iv.next();
                    BarcodeItem item2 = (BarcodeItem)e$iv;
                    $i$a$-minByOrNull-BaseBarcodeViewModelKt$getFocusedBarcode$1 = false;
                    double v$iv = BaseBarcodeViewModelKt.averagePointDistanceToFrameCenter(item2, area);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    public static final double averagePointDistanceToFrameCenter(@NotNull BarcodeItem item, @NotNull Rect area) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        ResultPoint[] $this$map$iv = item.getResultPoints();
        boolean $i$f$map = false;
        ResultPoint[] resultPointArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void point;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(ResultPoint.Companion.distance((ResultPoint)point, new ResultPoint((float)area.centerX(), (float)area.centerY()))));
        }
        return CollectionsKt.averageOfFloat((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final String getUniqueBarcodeUUID(@NotNull BarcodeItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return item.getTextWithExtension() + '_' + item.getBarcodeFormat().name();
    }

    @Nullable
    public static final Object loadData(@NotNull BarcodeItemMapper delegate, @NotNull io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeItem item, @NotNull Continuation<? super BarcodeMappedData> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super BarcodeMappedData> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation routine = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        delegate.mapBarcodeItem(item, new BarcodeMappingResult((CancellableContinuation<? super BarcodeMappedData>)routine){
            final /* synthetic */ CancellableContinuation<BarcodeMappedData> $routine;
            {
                this.$routine = $routine;
            }

            public void onResult(@NotNull BarcodeMappedData data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                ((Continuation)this.$routine).resumeWith(Result.constructor-impl((Object)data));
            }

            public void onError() {
                ((Continuation)this.$routine).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalStateException("Mapping failed"))));
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }
}

